% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssva.R
\name{ssva}
\alias{ssva}
\title{A function for estimating surrogate variables using a supervised approach}
\usage{
ssva(dat, controls, n.sv)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{controls}{A vector of probabilities (between 0 and 1, inclusive) that each gene is a control. A value of 1 means the gene is certainly a control and a value of 0 means the gene is certainly not a control.}

\item{n.sv}{The number of surogate variables to estimate}
}
\value{
sv The estimated surrogate variables, one in each column

pprob.gam: A vector of the posterior probabilities each gene is affected by heterogeneity (exactly equal to controls for ssva)

pprob.b A vector of the posterior probabilities each gene is affected by mod (always null for ssva)

n.sv The number of significant surrogate variables
}
\description{
This function implements a supervised surrogate variable analysis approach
where genes/probes known to be affected by artifacts but not by the biological
variables of interest are assumed to be known in advance. This supervised sva
approach can be called through the \code{\link{sva}} and \code{\link{svaseq}} functions
by specifying controls.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:5000,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)

n.sv = num.sv(edata,mod,method="leek")
set.seed(1234)
controls <- runif(nrow(edata))
ssva_res <- ssva(edata,controls,n.sv)

}
