---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, graphiques
---

# Comment tracer une courbe ?

## Avec l'extension [PGFPlots](ctanpkg:pgfplots)

:::{todo} Ajouter un exemple
:::


## Avec l'extension <ctanpkg:pst-plot> 

L'extension <ctanpkg:pst-plot> fait partie de l'ensemble <ctanpkg:pstricks>.
Elle permet de tracer des fonctions par la commande `\psplot` 
ou des courbes paramétriques par la commande `\parametricplot`. 
La définition mathématique des fonctions à dessiner est à rentrer 
en langage Postscript, dont il existe une 
[documentation intégrale](https://www.adobe.com/jp/print/postscript/pdfs/PLRM.pdf)
ainsi qu'un [résumé](https://web.archive.org/web/20060506032732/http://www.cs.indiana.edu/docproject/programming/postscript/postscript.html). 
Notez que Postscript est un langage qui utilise
la [notation polonaise inverse](wpfr:Notation_polonaise_inverse). 
Ainsi, pour calculer `\exp{\frac{x^2}{4}}`, il faudra saisir 
`x x mul 4 div exp`. L'exemple suivant illustre ce point et explicite
certaines techniques. Notez que nous utilisons ici le moteur LuaLaTeX 
pour traiter cet exemple car il est directement compatible 
avec <ctanpkg:pstricks>. 

```
%!TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pst-plot}

\begin{document}
\begin{pspicture}(-6.5,-6.5)(6.5,6.5)
% Tracé des axes. Les labels des abscisses sont traités à part pour avoir "pi"
\psaxes[linewidth=.5\pslinewidth,%
  Dx=3.1415,%
  labels=y]%
  {->}(0,0)(-6.5,-6.5)(6.5,6.5)
% \SpecialCoor permet de donner les coordonnées d'un point en utilisant 
% du code PostScript avec un point d'exclamation 
\SpecialCoor
% (! 3.1415 2 mul 0) est le code PostScript pour dire (-2pi,0)
% Cela évite la calculatrice et permet d'automatiser l'affichage des labels
% formels contenant par exemple \pi ou \mathrm{e} en utilisant \multido.
\uput[-90](! 3.1415 2 mul neg 0){$-2\pi$}
\uput[-90](! 3.1415 neg 0){$-\pi$}
\uput[-90](! 3.1415 0){$\pi$}
\uput[-90](! 3.1415 2 mul 0){$2\pi$}
%
% Courbe de "y=x"
\psplot[linecolor=red]{-6.4}{6.4}{x}
%
% Courbe de "y=(sin x)/x"
% En PostScript, l'argument de sin est en degrés. Ici, il faut des radians,
% d'où la conversion.
\psplot[linecolor=green,plotpoints=500]{-6.4}{6.4}{%
  x 360 3.1415 div mul sin x mul}
%
% Dessin de "y=arctan x"
% Pour obtenir arctan x, le code PostScript est x 1 atan car atan donne 
% arctan du rapport des deux éléments du dessus de la pile.
% Attention, la fonction atan de Postcript n'est pas bien définie... puisque
% pour x<0, x 1 atan donne quelque chose à valeur dans [3\pi/2,\pi]
\psplot[linecolor=blue,linestyle=dashed,plotpoints=500]{-6.4}{6.4}%
  {x 1 atan 3.1415 360 div mul}
% Il faut donc tracer arctan par morceaux en rusant un peu...
\psplot[linecolor=blue,plotpoints=250]{-6.4}{-0.0001}%
  {x 1 atan 3.1415 360 div mul 3.1415 sub}
\psplot[linecolor=blue,plotpoints=250]{0.0001}{6.4}%
  {x 1 atan 3.1415 360 div mul}
\end{pspicture}
\end{document}
```