"EXP.cov"<-
function(x1, x2, theta = rep(1, ncol(x1)), p = 1, C = NA)
{
	if(!is.loaded(symbol.For("expbs"))) {
	#	temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
	#		""), 2)
          stop("dynamic library code not loaded!")
	}
	if(!is.matrix(x1))
		x1 <- as.matrix(x1)
	if(missing(x2))
		x2 <- x1
	if(!is.matrix(x2))
		x2 <- as.matrix(x2)	#
	if(length(theta) == 1)
		theta <- rep(theta, ncol(x1))
	d <- ncol(x1)
	n1 <- nrow(x1)
	n2 <- nrow(x2)	# scale both X's to reflect theta parameter
	x1 <- t(t(x1)/theta)
	x2 <- t(t(x2)/theta)	#	make.gaspb(x1, x2, p)
	par <- p
	if(is.na(C[1])) {
#
#
# return the full covariance matrix
		exp( - rdist(x1, x2)^p)
	}
	else {
###
##
# return the covaraince matrix multiplied by the vector C
#
		.Fortran("multeb",
			nd = as.integer(d),
			x1 = as.double(x1),
			n1 = as.integer(n1),
			x2 = as.double(x2),
			n2 = as.integer(n2),
			par = as.double(par),
			c = as.double(C),
			h = as.double(rep(0, n1)),
			work = as.double(rep(0, n2)))$h
	}
}
