"exp.isocor"<-
function(x1, x2, theta = 1, alpha = 1, obj = 1, marginal = F, lon.lat = F, cor
	 = F)
{
	if(is.character(obj))
		obj <- get(obj)	#
	if(is.numeric(obj)) {
		if(length(obj) == 1)
			class(obj) <- "constant"
	}
#
# return marginal variance if marginal =T
#
	if(marginal)
		return(c(predict(obj, x1))^2)	#
	if(missing(x2)) {
		x2 <- x1
	}
#
#
#
#
# switch to use either geographic distance based on lon-lat
# or the normal cartesian distance
#
	if(lon.lat) {
		temp <- alpha * exp( - rdist.earth(x1, x2)/theta)
	}
	else {
		temp <- alpha * exp( - rdist(x1, x2)/theta)
	}
	temp[temp >= (alpha - 9.9999999999999995e-08)] <- 1
	if(cor)
		return(temp)
	else {
		s1 <- c(predict(obj, x1))
		s2 <- c(predict(obj, x2))
		return(s1 * t(t(temp) * s2))
	}
}
