"make.gaspb"<-
function(x1, x2, p = rep(1, ncol(x1)))
{
	if(!is.loaded(symbol.For("gaspbs"))) {
	#	temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
	#		""), 2)
          stop("dynamic library code not loaded!")
	}
	if(!is.matrix(x1))
		x1 <- as.matrix(x1)
	if(!is.matrix(x2))
		x2 <- as.matrix(x2)
	d <- ncol(x1)
	n1 <- nrow(x1)
	n2 <- nrow(x2)
	par <- p
	temp <- .Fortran("gaspbs",
		nd = as.integer(d),
		x1 = as.double(x1),
		n1 = as.integer(n1),
		x2 = as.double(x2),
		n2 = as.integer(n2),
		par = as.double(par),
		k = as.double(rep(0, n1 * n2)))
	matrix(temp$k, ncol = n2, nrow = n1)
}
