"map.cov"<-
function(xy1, xy2 = NULL, data, marginal = F, cor = F)
{
# if name of data set is given get it 
#
	if(is.character(data)) data <- get(data)	#
#
#
	if(marginal) {
		return(c(predict(data$sd.obj, xy1)^2))
	}
#
#
#
	uv1 <- predict(data$map.obj, xy1)
	if(!is.null(xy2)) {
		uv2 <- predict(data$map.obj, xy2)
	}
	else {
		uv2 <- uv1
	}
	temp <- data$cov.function(uv1, uv2)
	if(cor)
		return(temp)
	else {
		s1 <- c(predict(data$sd.obj, xy1))
		if(!is.null(xy2)) {
			s2 <- c(predict(data$sd.obj, xy2))
		}
		else {
			s2 <- s1
		}
		return(s1 * t(t(temp) * s2))
	}
}
