"minimax.crit"<-
function(obj, des = T, R)
{
### this is the minimax criterion for the final coverage design
### object must be the final design for cover.deisgn.F when des=T
### when des=F, the object must be the number of the row matched with
### R ex) rowmatch(grid.ex,R)
	R <- as.matrix(R)
	id <- 1:nrow(R)
	if(des)
		Dset <- attr(obj, "best.id")
	else Dset <- obj
	Cset <- id[ - Dset]
	dist.mat <- rdist(R[Cset,  ], R[Dset,  ])
	mM.crit <- max(apply(dist.mat, 1, min))
	mM.crit
}
