"nkreg"<-
function(data.x, data.y, bandwidth, n.points, grid)
{
	if(!is.loaded(symbol.For("nkreg"))) {
	#	temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
	#		""), 2)
          stop("dynamic library code not loaded!")
	}
# who wants to keep typing bandwidth!]
	h <- bandwidth	# reformat 1-d vector as column matrix
	if(data.class(data.x) == "data.frame")
		data.x <- as.matrix(data.x)
	if(!is.matrix(data.x))
		m <- 1
	else m <- ncol(data.x)
	if(missing(grid)) {
		if((m == 1))
			if(!missing(n.points))
				grid <- seq(min(data.x), max(data.x),  , 
				  n.points)
			else grid <- (data.x)
		else grid <- data.x
	}
	if(data.class(grid) == "data.frame")
		grid <- as.matrix(grid)
	if(m > 1) {
		if(m != ncol(grid))
			stop("dimension of data.x and grid do not agree")
		p <- nrow(grid)
		n <- nrow(data.x)
	}
	else {
		p <- length(grid)
		n <- length(grid)
	}
	nh <- length(h)
	f <- matrix(rep(-99, p * nh), ncol = nh)
	out <- list()
	for(k in 1:nh) {
		out <- .Fortran("nkreg",
			as.double(h[k]),
			as.integer(n),
			as.integer(m),
			as.double(data.x),
			as.double(data.y),
			as.integer(p),
			as.double(grid),
			as.double(rep(-99, p)))
		f[, k] <- out[[8]]
	}
	if(nh == 1)
		f <- c(f)
	list(x = grid, y = f, h = h, fitted.values = f)
}
