"spread.design"<-
function(region = grid, n = 5, P = -5, Q = 1, nruns = 1, start = NA, existing
	 = NULL, keep = NULL, DIST = rdist)
{
	if(!is.null(existing)) {
		if(is.null(nrow(existing)))
			existing <- t(as.matrix(existing))
		region <- rbind(region, existing)
	}
	keep.n <- 0
	keep.id <- NULL
	if(!is.null(keep)) {
		keep.id <- keep
		keep.n <- length(keep)
		keep <- region[keep,  ]
	}
	id <- 1:nrow(region)
	saved.crit <- rep(NA, nruns)
	saved.designs <- matrix(NA, nrow = nruns, ncol = n)
	saved.hist <- list()
	for(RUNS in 1:nruns) {
		if(is.na(start)) {
			if(!is.null(keep.id))
				sam <- c(keep.id, sample(c(1:nrow(region))[ - 
				  keep.id], n - keep.n))
			else sam <- sample(c(1:nrow(region)), n - keep.n)
		}
		else sam <- start
		st <- st.orig <- region[sam,  ]
		gr <- gr.orig <- region[ - sam,  ]
		hold <- DIST(st, st)^P
		diag(hold) <- 0
		rs <- hold %*% rep(1, n)
		crit.orig <- crit.o <- crit.last <- sum(rs^(Q/P))^(1/Q)
		hist <- c(0, 0, crit.o)
		repeat {
			best.val <- best.spot <- NULL
			CRIT <- rep(NA, nrow(gr))
			for(i in (keep.n + 1):n) {
				hold <- DIST(st, st)^P
				diag(hold) <- 0
				rowindex <- (1:n)[ - i]
				zeros <- rep(0, n)
				D <- DIST(gr, st[ - i,  ])^P
				for(j in 1:nrow(gr)) {
				  zeros[rowindex] <- D[j,  ]
				  hold[i,  ] <- hold[, i] <- zeros
				  CRIT[j] <- sum((hold %*% rep(1, n))^(Q/P))^(1/
				    Q)
				}
				best.val <- max(CRIT)
				best.spot <- id[ - sam][CRIT == best.val][1]
				if(best.val > crit.o) {
				  crit.o <- best.val
				  hist <- rbind(hist, c(sam[i], best.spot, 
				    crit.o))
				  sam[i] <- best.spot
				  st <- region[sam,  ]
				  gr <- region[ - sam,  ]
				}
			}
			if(crit.o == crit.last)
				break
			crit.last <- crit.o
		}
		saved.crit[RUNS] <- crit.o
		saved.designs[RUNS,  ] <- sam
		saved.hist[[RUNS]] <- hist
	}
	ret <- (1:nruns)[saved.crit == min(saved.crit)]
	if(length(ret) > 1) {
		print("Greater than 1 optimal design; keeping first one....")
		ret <- ret[1]
	}
	crit.o <- saved.crit[ret]
	hist <- saved.hist[[ret]]
	history <- cbind(0:(nrow(hist) - 1), hist)
	dimnames(history) <- list(NULL, c("step", "swap.out", "swap.in", 
		"new.crit"))
	st <- region[saved.designs[ret,  ],  ]
	list(best.design = st, opt.crit = crit.o, start.design = st.orig, 
		start.crit = crit.orig, history = history, other.designs = 
		saved.designs, other.crit = saved.crit, kept.points = keep)
}
