"sreg"<-
function(x, y, lam = NA, offset = 0, wt = rep(1, length(x)), cost = 1, nstep.cv
	 = 50, maxit.cv = 10, deriv = 0, find.trA = T, trmin = 
	2.0099999999999998, trmax = length(unique(x)) * 0.94999999999999996, 
	lammin = NA, lammax = NA)
{
	call <- match.call()
	if(!is.loaded(symbol.For("css"))) {
	#	temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
	#		""), 2)
          stop("dynamic library code not loaded!")
	}
	out <- list()
	out$call <- match.call()
	class(out) <- c("sreg", "funfits")
	N <- length(y)
	out$N <- N
	if(length(x) != length(y))
		stop(" X and Y do not match")
	do.cv <- is.na(lam[1])
	xgrid <- sort(unique(x))
	if(do.cv) {
		hmin <- log(lammin)
		hmax <- log(lammax)	#
#
#first find good ranges for the smoothing parameters
#
		if(is.na(hmin)) {
			hmin <- 0
			for(k in 1:25) {
				b <- sreg.trace(lam = as.double(exp(hmin)), x
				   = x, y = y, wt = wt, cost = cost)
				if(b > trmax) {
				  break
				}
				hmin <- hmin - 1
			}
		}
		if(is.na(hmax)) {
			hmax <- 0
			for(k in 1:25) {
				b <- sreg.trace(lam = as.double(exp(hmax)), x
				   = x, y = y, wt = wt, cost = cost)
				if(b < trmin) {
				  break
				}
				hmax <- hmax + 1
			}
		}
		a <- .Fortran("gcvcss",
			n = as.integer(N),
			x = as.double(x),
			y = as.double(y),
			wt = as.double(wt),
			cost = as.double(cost),
			offset = as.double(offset),
			nstep = as.integer(nstep.cv),
			maxit = as.integer(maxit.cv),
			hmin = as.double(hmin),
			hmax = as.double(hmax),
			hopt = as.double(-1),
			vopt = as.double(-1),
			tropt = as.double(-1),
			mxstep = as.integer(nstep.cv),
			tabout = as.double(rep(0, 3 * nstep.cv)),
#			work = as.double(rep(0, N)), 
			ierr = as.integer(0))
		if(a$ierr == -1) {
			cat("minimum CV is at the\nboundary of the grid for minimization",
				fill = T)
		}
		if(a$ierr > 0) {
			cat("Error in call to cv search", "error code=", a$ierr,
				fill = T)	#			return(a)
		}
	}
	if(do.cv) {
		lam <- exp(a$hopt)
	}
	b <- list()
	NL <- length(lam)
	NG <- length(xgrid)
	h <- log(lam)
	residuals <- matrix(0, ncol = NL, nrow = N)
	if(find.trA) {
		diagA <- residuals
	}
	else {
		diagA <- matrix(0, ncol = NL)
	}
	cv <- rep(0, NL)
	predicted <- matrix(0, ncol = NL, nrow = NG)
	trace <- rep(0, NL)
	converge <- rep(0, NL)
	if(find.trA) {
		job <- as.integer(c(3, 3, 0))
	}
	else {
		job <- as.integer(c(0, 3, 0))
	}
	for(k in 1:NL) {
#      subroutine css(h,npoint,x,y,wght,sy,trace,diag,vlam,  
#     +                  ngrid,xg,yg,job,ideriv,ierr)  
		b <- .Fortran("css",
			h = as.double(h[k]),
			npoint = as.integer(N),
			x = as.double(x),
			y = as.double(y),
			wt = as.double(wt),
			sy = as.double(rep(0, N)),
			trace = as.double(0),
			diag = as.double(c(cost, offset, rep(0, (N - 2)))),
			cv = as.double(0),
			ngrid = as.integer(NG),
			xg = as.double(xgrid),
			yg = as.double(rep(0, NG)),
			job = as.integer(job),
			ideriv = as.integer(deriv),
			ierr = as.integer(0))	#
		if(find.trA) {
			diagA[, k] <- b$diag
			cv[k] <- b$cv
			trace[k] <- b$trace
		}
		else {
			diagA[, k] <- NA
			cv[k] <- NA
			trace[k] <- NA
		}
		residuals[, k] <- y - b$sy
		predicted[, k] <- b$yg
	}
	if(do.cv) {
		cv.grid <- matrix(a$tabout, ncol = 3)
		cv.grid[, 1] <- exp(cv.grid[, 1])
		temp <- cost * (cv.grid[, 2] - 2) + 2
		rss <- N * cv.grid[, 3] * (1 - (temp/N))^2
		cv.grid <- cbind(cv.grid, sqrt(rss/(N - cv.grid[, 2])))
		shat <- c(t(residuals^2) %*% rep(1, N))
		shat <- sqrt(shat/(N - trace))
	}
	else {
		if(find.trA) {
			shat <- c(t(residuals^2) %*% rep(1, N))
			shat <- sqrt(shat/(N - trace))
			cv.grid <- cbind(lam, trace, cv, shat)
		}
		else {
			shat <- NA
			cv.grid <- matrix(NA, ncol = 4)
		}
	}
	dimnames(cv.grid) <- list(NULL, c("lambda", "trace", "GCV", "sigma hat"
		))
	out$call <- call
	out$x <- x
	out$y <- y
	out$GCV <- out$do.cv
	out$residuals <- residuals
	out$fitted.values <- y - residuals
	out$predicted <- list(x = xgrid, y = predicted)
	out$gcv.grid <- cv.grid
	out$trace <- trace
	out$lambda <- lam
	out$diagA <- diagA
	out$shat <- shat
	out
}
