"vgram"<-
function(loc, y, lon.lat = F)
{
	loc <- as.matrix(loc)
	n <- nrow(loc)
	ind <- rep(1:n, n) > rep(1:n, rep(n, n))
	id <- cbind(rep(1:n, n), rep(1:n, rep(n, n)))[ind,  ]
	if(lon.lat) {
		d <- c(rdist.earth(loc))[ind]
	}
	else {
		d <- dist(loc)
	}
	temp <- 0.5 * (y[id[, 1]] - y[id[, 2]])^2
	call <- match.call()
	out <- list(d = d, vgram = temp, id = id, loc = loc, call = call)
	class(out) <- "vgram"
	out
}
