\name{predict.tps}
\alias{predict.tps}
\title{
Evaluation of thin plate spline surface.
}
\description{
Provides predictions from tps, given an x matrix.
}
\usage{
predict.tps(out, x, y,lambda,  df, omega,derivative=0, model=NA)
}
\arguments{
\item{out}{
Fitted tps object.
}
\item{x}{
Matrix of x values on which to evaluate the thin plate spline surface.
If omitted, out$x will be used.
}
\item{y}{
New y values, spline will be recomupted using these new data.
(The tps object needs to have been created using return.X for this to
work.) 
}
\item{lambda}{
Smoothing parameter. If omitted, out$lambda will be used.
}
\item{df}{
Specifies effective degrees of freedom for the spline model. 
}
\item{omega}{
Parameter vector for the spline in the Demmelre Reinsch form. If passed
the spline will be recomputed using these new parameters. 
}
\item{derivative}{
Derivative of function is returned if derivative=1.
Generic argument that may be used to pass a different lambda.
}}
\value{
Vector of predicted responses. If derivative=1 a vector of
derivatives or a matrix of partial derivatives is returned.
}
\seealso{
tps, predict.surface
}
\examples{
tps(ozone$x,ozone$y) -> fit                 # tps fit
cbind(seq(87,89,,10),seq(40,42,,10)) -> x   # new x matrix
predict(fit,x) -> out                       # evaluate fit at x
predict(fit,x,df=10)-> out                # evaluate spline with 10
                                          # effective degrees of freeedom
}
\keyword{splines,}
% Converted by Sd2Rd version 0.3-2.
