"as.kernel.cov"<-
function(cov.mat, loc, cov.function = exp.isocor, rho = 1, M = 5, ...)
{
# find difference between correlation matrix and that estimated by
# isotropic exponential model. 
#
# fit surface to marginal standard deviations. 
#
# add passed arguments to the covariance function
#
	temp <- list(...)
	ntemp <- names(temp)
	if(length(temp) > 0) {
		for(k in 1:length(ntemp)) {
			cov.function[ntemp[k]] <- temp[ntemp[k]]
		}
		cov.function <- as.function(cov.function)
	}
#
	res1 <- cov.mat - rho * cov.function(loc, loc)	
	# eigen vector-eigenvalue decomposition of correlation matrix minus
# the parametric  covariance defined by cov.function
#
	temp <- eigen(res1)	#
#
	temp.e <- temp$values
	print(temp.e)
	e.neg <- min(temp.e[temp.e < 0])
	if(is.na(e.neg))
		e.neg <- 0
	cat(" first eigenvalue", temp.e[1], fill = T)
	cat("most  negative is ", e.neg, fill = T)	##
###
	if(temp.e[M] < abs(e.neg)) {
		M <- sum(temp.e > abs(e.neg))
		if(M > 1)
			warning(" Some negative eigenvalues found! M has been reset "
				)
		else {
			stop("Largest eigenvalue in absolute value is negative!"
				)
		}
	}
#
## save eigenvectors
#
	U <- temp$vectors[, 1:M]	#
# calculate residuals
#
	res <- res1 - U %*% (temp.e[1:M] * t(U))	#
# fit surfaces to eigen functions
#
	fits <- as.list(1:M)
	for(k in 1:M) {
		fits[[k]] <- tps(loc, U[, k], lambda = 0, return.matrices = F)
	}
#
#        Now make up weights 
	delta <- temp.e
	temp.e <- temp.e[1:M]
	call <- match.call()	#
#
	list(loc = loc, delta = delta, fits = fits, rho = rho, U = U, M = M, 
		call = call, cov.function = cov.function, residuals = res)
}
