"make.Kc.S"<-
function(x1, x2, C, p = 1, with.log = T, with.constant = T)
{
# if the C vector ( number of points to evaluate spline at is big)
# then loop to avoid createing a huge matrix 
# e.g. if the fit had 150 data points and the points to evaluate were
# 1600 then the the matrix from make.rb would be    1600X150 !
#
# Why blocks of 200?  Hmmm,  good question.
#
#
	N <- nrow(x1)
	if(N < 200) {
		return(c(make.rb(x1, x2, p = p, with.log = with.log, 
			with.constant = with.constant) %*% C))
	}
	else {
		out <- rep(NA, N)
		M <- floor(N/200)
		i1 <- 1
		for(k in 1:M) {
			i2 <- i1 + 200 - 1
			out[i1:i2] <- c(make.rb(x1[i1:i2,  ], x2, p = p, 
				with.log = with.log, with.constant = 
				with.constant) %*% C)
			i1 <- i1 + 200
		}
# Now do the last block that is not 200 long ( if it exists)
		if(i1 < N) {
			out[i1:N] <- c(make.rb(x1[i1:N,  ], x2, p = p, with.log
				 = with.log, with.constant = with.constant) %*% 
				C)
		}
		out
	}
}
