"nkden.cv"<-
function(data, h)
{
	if(!is.loaded(symbol.For("nkden"))) {
		temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
			""), 2)
	}
# reformat 1-d vector as column matrix
	if(!is.matrix(data)) {
		data <- matrix(data, ncol = 1, byrow = T)
	}
# if h is missing  choose agrid based on the data
	if(missing(h)) {
		hold <- stats(data)
		n <- hold[1, 1]
		rng <- hold[8,  ] - hold[4,  ]
		hmin <- min(rng)/n
		hmax <- max(rng)/2
		h <- seq(hmin, hmax,  , 40)
	}
	m <- ncol(data)
	n <- nrow(data)
	nh <- length(h)
	cvf <- rep(-99, nh)
	out <- .Fortran("lscv",
		as.integer(nh),
		as.double(h),
		as.integer(n),
		as.integer(m),
		as.double(data),
		as.double(cvf))
	temp <- out[[6]]
	list(h = h, CV.f = temp, h.CV = h[min(temp) == temp])
}
