"nn.res"<-
function(xmat, y, num.neigh = 5, FUN = mean)
{
	xmat <- as.matrix(xmat)
	if(length(y) != dim(xmat)[[1]]) {
		print("dimensions of X and y don't match")
		return()
	}
	xmat <- apply(xmat, 2, scale.01)
	nx <- dim(xmat)[[1]]
	distmat <- rdist(xmat, xmat)
	diag(distmat) <- 0
	temp <- apply(distmat, 1, closest.n, n = num.neigh)
	nn.res <- centers <- rep(NA, dim(xmat)[1])
	for(i in 1:dim(xmat)[1]) {
		centers[i] <- FUN(y[temp[[i]]])
		nn.res[i] <- y[i] - centers[i]
	}
	list(nn.res = nn.res, centers = centers)
}
