"plot.case.tpsreg"<-
function(x, case, digits = 2)
{
	y <- x$y
	n <- length(y)
	if(missing(case))
		case <- 1:n
	plot(case, y, xlab = "Case", ylab = "Observed")
	points(case, x$fit, mark = 4)
	lines(case[order(case)], x$fit[order(case)], lty = 2)
	aov1 <- aov(y ~ factor(case))
	pure.error <- sqrt(sum(aov1$residuals^2)/aov1$df.resid)
	res <- x$resid
	rmse <- sqrt(sum(res^2)/(n - x$eff.df))
	title(paste("TPSREG Results: M =", x$m, "; Spar =", signif(x$spar, 3), 
		"; Obs. =", length(x$y), "; R.sq =", round(100 * cor(x$y, x$fit
		)^2, 2), "%", "\n", "DFmod =", round(x$eff.df, 1), "; DFres. =",
		round(n - x$eff.df, 1), "; RMSE =", signif(rmse, digits), 
		"; PE =", signif(pure.error, digits)))
}
