"tps.parm"<-
function(out)
{
	xnames <- names(data.frame(out$x))
	parnames <- rep(NA, dim(out$ptab)[1])
	parnames[1] <- "int"
	if(is.null(out$null.model)) {
		for(i in 2:dim(out$ptab)[1]) {
			if(sum(out$ptab[i,  ] > 1) > 0) {
				parnames[i] <- paste(paste(xnames[out$ptab[i,  
				  ] > 0], collapse = "*"), paste(xnames[out$
				  ptab[i,  ] > 1], collapse = "*"), sep = "*")
			}
			else parnames[i] <- paste(xnames[out$ptab[i,  ] > 0], 
				  collapse = "*")
		}
	}
	else parnames <- dimnames(out$ptab)[[1]]
	parm.coef <- out$d
	M <- make.Mmatrix.tps(out)
	se <- sqrt(diag((out$shat)^2 * t(M) %*% M))
	tstat <- parm.coef/se
	df <- data.frame(parm.coef, se, tstat)
	row.names(df) <- parnames
	df
}
