/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetOutputStream;

class T4CSocketOutputStreamWrapper
extends OutputStream {
    static final int MAX_BUFFER_SIZE = 2048;
    NetOutputStream os = null;
    byte[] buffer = new byte[2048];
    int bIndex = 0;

    T4CSocketOutputStreamWrapper(NetOutputStream netOutputStream) throws IOException {
        this.os = netOutputStream;
    }

    public void write(int n2) throws IOException {
        if (this.bIndex + 1 >= 2048) {
            this.flush();
        }
        this.buffer[this.bIndex++] = (byte)(n2 & 0xFF);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 2048) {
            this.flush();
            this.os.write(byArray, n2, n3);
        } else if (this.bIndex + n3 < 2048) {
            System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
            this.bIndex += n3;
        } else {
            this.flush();
            System.arraycopy(byArray, n2, this.buffer, this.bIndex, n3);
            this.bIndex += n3;
        }
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean bl) throws IOException {
        if (this.bIndex > 0) {
            this.os.write(this.buffer, 0, this.bIndex);
            this.bIndex = 0;
        }
        if (bl) {
            this.os.flush();
        }
    }

    public void close() throws IOException {
        this.os.close();
        super.close();
    }

    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException, BreakNetException {
        this.flush(true);
        this.os.writeZeroCopyIO(byArray, n2, n3);
    }
}

