/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.properties.CommonMarginBlock;

public class RegionBody
extends Region {
    private CommonMarginBlock commonMarginBlock;
    private Numeric columnCount;
    private Length columnGap;

    public RegionBody(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.columnCount = pList.get(68).getNumeric();
        this.columnGap = pList.get(69).getLength();
        if (this.getColumnCount() > 1 && this.getOverflow() == 126) {
            this.attributeError("If overflow property is set to \"scroll\", a column-count other than \"1\" may not be specified.");
        }
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public int getColumnCount() {
        return this.columnCount.getValue();
    }

    public int getColumnGap() {
        return this.columnGap.getValue();
    }

    public Rectangle getViewportRectangle(FODimension reldims) {
        int left = this.commonMarginBlock.marginLeft.getValue();
        int right = this.commonMarginBlock.marginRight.getValue();
        int top = this.commonMarginBlock.marginTop.getValue();
        int bottom = this.commonMarginBlock.marginBottom.getValue();
        return new Rectangle(left, top, reldims.ipd - left - right, reldims.bpd - top - bottom);
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    public String getName() {
        return "fo:region-body";
    }

    public int getNameId() {
        return 36;
    }
}

