/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.LengthProperty;

public class PercentLength
extends LengthProperty {
    private double factor;
    private PercentBase lbase = null;

    public PercentLength(double factor, PercentBase lbase) {
        this.factor = factor;
        this.lbase = lbase;
    }

    public PercentBase getBaseLength() {
        return this.lbase;
    }

    public double value() {
        return this.factor;
    }

    public boolean isAbsolute() {
        return false;
    }

    public double getNumericValue() {
        try {
            return this.factor * (double)this.lbase.getBaseLength();
        }
        catch (PropertyException exc) {
            log.error(exc);
            return 0.0;
        }
    }

    public int getValue() {
        return (int)this.getNumericValue();
    }

    public String toString() {
        return new Double(this.factor * 100.0).toString() + "%";
    }
}

