/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSProcSets;
import org.apache.fop.render.ps.PSXMLHandler;
import org.apache.fop.traits.BorderProps;
import org.w3c.dom.Document;

public class PSRenderer
extends PrintRenderer {
    public static final String MIME_TYPE = "application/postscript";
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    protected PSGenerator gen;
    private boolean ioTrouble = false;
    private String currentFontName;
    private int currentFontSize;
    private float currRed;
    private float currGreen;
    private float currBlue;

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        this.autoRotateLandscape = cfg.getChild("auto-rotate-landscape").getValueAsBoolean(false);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PSXMLHandler xmlHandler = new PSXMLHandler();
        this.userAgent.getXMLHandlerRegistry().addXMLHandler(xmlHandler);
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            log.error("Error while writing to target file", ioe);
            this.ioTrouble = true;
        }
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            this.writeln(comment);
        }
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void moveTo(int x, int y) {
        this.writeln(x + " " + y + " M");
    }

    public void saveGraphicsState() {
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void restoreGraphicsState() {
        try {
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void beginTextObject() {
        this.writeln("BT");
    }

    protected void endTextObject() {
        this.writeln("ET");
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void fillRect(float x, float y, float w, float h, ColorType col) {
        this.useColor(col);
        this.writeln(this.gen.formatDouble(x) + " " + this.gen.formatDouble(y) + " " + this.gen.formatDouble(w) + " " + this.gen.formatDouble(h) + " rectfill");
    }

    protected void drawRect(float x, float y, float w, float h) {
        this.writeln(this.gen.formatDouble(x) + " " + this.gen.formatDouble(y) + " " + this.gen.formatDouble(w) + " " + this.gen.formatDouble(h) + " rectstroke");
    }

    protected void clip(float x, float y, float width, float height) {
        this.writeln(x + " " + y + " " + width + " " + height + " rectclip");
    }

    public void useFont(String name, int size) {
        if (this.currentFontName != name || this.currentFontSize != size) {
            this.writeln(name + " " + size + " F");
            this.currentFontName = name;
            this.currentFontSize = size;
        }
    }

    private void useColor(ColorType col) {
        this.useColor(col.getRed(), col.getGreen(), col.getBlue());
    }

    private void useColor(float red, float green, float blue) {
        if (red != this.currRed || green != this.currGreen || blue != this.currBlue) {
            this.writeln(this.gen.formatDouble(red) + " " + this.gen.formatDouble(green) + " " + this.gen.formatDouble(blue) + " setrgbcolor");
            this.currRed = red;
            this.currGreen = green;
            this.currBlue = blue;
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        log.debug("rendering areas to PostScript");
        this.gen = new PSGenerator(outputStream);
        this.currentPageNumber = 0;
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{this.userAgent.getProducer()});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("LanguageLevel", new Integer(this.gen.getPSLevel()));
        this.gen.writeDSCComment("Pages", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSProcSets.writeFOPStdProcSet(this.gen);
        PSProcSets.writeFOPEPSProcSet(this.gen);
        PSProcSets.writeFontDict(this.gen, this.fontInfo);
        this.gen.writeln("FOPFonts begin");
        this.gen.writeDSCComment("EndSetup");
    }

    public void stopRenderer() throws IOException {
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", new Integer(this.currentPageNumber));
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        log.debug("renderPage(): " + page);
        ++this.currentPageNumber;
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumberString(), new Integer(this.currentPageNumber)});
        Integer zero = new Integer(0);
        long pagewidth = Math.round(page.getViewArea().getWidth());
        long pageheight = Math.round(page.getViewArea().getHeight());
        double pspagewidth = (float)pagewidth / 1000.0f;
        double pspageheight = (float)pageheight / 1000.0f;
        boolean rotate = false;
        if (this.autoRotateLandscape && pageheight < pagewidth) {
            rotate = true;
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspageheight)), new Long(Math.round(pspagewidth))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspageheight), new Double(pspagewidth)});
            this.gen.writeDSCComment("PageOrientation", "Landscape");
        } else {
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspagewidth)), new Long(Math.round(pspageheight))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspagewidth), new Double(pspageheight)});
            if (this.autoRotateLandscape) {
                this.gen.writeDSCComment("PageOrientation", "Portrait");
            }
        }
        this.gen.writeDSCComment("BeginPageSetup");
        if (rotate) {
            this.gen.writeln(Math.round(pspageheight) + " 0 translate");
            this.gen.writeln("90 rotate");
        }
        this.gen.writeln("<<");
        this.gen.writeln("/PageSize [" + Math.round(pspagewidth) + " " + Math.round(pspageheight) + "]");
        this.gen.writeln("/ImagingBBox null");
        this.gen.writeln(">> setpagedevice");
        this.gen.writeln("0.001 0.001 scale");
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, pageheight);
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeDSCComment("EndPage");
    }

    protected void paintText(int rx, int bl, String text, Typeface font) {
        this.saveGraphicsState();
        this.writeln("1 0 0 -1 " + rx + " " + bl + " Tm");
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        sb.append("(");
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char mapped = font.mapChar(c);
            PSGenerator.escapeChar(mapped, sb);
        }
        sb.append(") t");
        this.writeln(sb.toString());
        this.restoreGraphicsState();
    }

    public void renderText(TextArea area) {
        String fontname = (String)area.getTrait(Trait.FONT_NAME);
        int fontsize = area.getTraitAsInteger(Trait.FONT_SIZE);
        Typeface f = (Typeface)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentIPPosition;
        int bl = this.currentBPPosition + area.getOffset();
        this.useFont(fontname, fontsize);
        ColorType ct = (ColorType)area.getTrait(Trait.COLOR);
        if (ct != null) {
            this.useColor(ct);
        }
        this.paintText(rx, bl, area.getTextArea(), f);
        super.renderText(area);
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        String saveFontName = this.currentFontName;
        CTM ctm = bv.getCTM();
        if (bv.getPositioning() == 2) {
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.endTextObject();
            if (bv.getClip()) {
                this.saveGraphicsState();
                int x = bv.getXOffset() + this.containingIPPosition;
                int y = bv.getYOffset() + this.containingBPPosition;
                int width = bv.getIPD();
                int height = bv.getBPD();
                this.clip(x, y, width, height);
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.startVParea(ctm);
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            this.endVParea();
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            this.beginTextObject();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            if (ctm != null) {
                this.currentIPPosition = 0;
                this.currentBPPosition = 0;
                this.endTextObject();
                double[] vals = ctm.toArray();
                ctm = vals[2] == 1.0 ? ctm.translate(-saveBP - bv.getBPD(), -saveIP) : (vals[0] == -1.0 ? ctm.translate(-saveIP - bv.getIPD(), -saveBP - bv.getBPD()) : ctm.translate(saveBP, saveIP - bv.getIPD()));
            }
            if (bv.getClip()) {
                if (ctm == null) {
                    this.endTextObject();
                }
                this.saveGraphicsState();
                int x = bv.getXOffset();
                int y = bv.getYOffset();
                int width = bv.getIPD();
                int height = bv.getBPD();
                this.clip(x, y, width, height);
            }
            if (ctm != null) {
                this.startVParea(ctm);
            }
            this.handleBlockTraits(bv);
            this.renderBlocks(bv, children);
            if (ctm != null) {
                this.endVParea();
            }
            if (bv.getClip()) {
                this.restoreGraphicsState();
                if (ctm == null) {
                    this.beginTextObject();
                }
            }
            if (ctm != null) {
                this.beginTextObject();
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
        this.currentFontName = saveFontName;
    }

    protected void startVParea(CTM ctm) {
        this.saveGraphicsState();
        double[] matrix = ctm.toArray();
        this.concatMatrix(matrix);
        this.beginTextObject();
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
    }

    protected void handleRegionTraits(RegionViewport region) {
        this.currentFontName = "";
        float startx = 0.0f;
        float starty = 0.0f;
        Rectangle2D viewArea = region.getViewArea();
        float width = (float)viewArea.getWidth();
        float height = (float)viewArea.getHeight();
        this.drawBackAndBorders(region, startx, starty, width, height);
    }

    protected void handleBlockTraits(Block block) {
        float startx = this.currentIPPosition;
        float starty = this.currentBPPosition;
        this.drawBackAndBorders(block, startx, starty, block.getIPD(), block.getBPD());
    }

    protected void drawBackAndBorders(Area block, float startx, float starty, float width, float height) {
        float bwidth;
        BorderProps bps;
        boolean started = false;
        Trait.Background back = (Trait.Background)block.getTrait(Trait.BACKGROUND);
        if (back != null) {
            ImageFactory fact;
            FopImage fopimage;
            started = true;
            this.endTextObject();
            if (back.getColor() != null) {
                this.fillRect(startx, starty, width, height, back.getColor());
            }
            if (back.getURL() != null && (fopimage = (fact = ImageFactory.getInstance()).getImage(back.getURL(), this.userAgent)) != null && fopimage.load(1) && back.getRepeat() != 112) {
                Rectangle2D.Float pos = new Rectangle2D.Float((startx + (float)back.getHoriz()) * 1000.0f, (starty + (float)back.getVertical()) * 1000.0f, fopimage.getWidth() * 1000, fopimage.getHeight() * 1000);
            }
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_BEFORE)) != null) {
            float endx = startx + width;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            float bwidth2 = bps.width;
            this.useColor(bps.color);
            this.writeln(bwidth2 + " setlinewidth");
            this.drawLine(startx, starty + bwidth2 / 2.0f, endx, starty + bwidth2 / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_START)) != null) {
            float endy = starty + height;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            float bwidth3 = bps.width;
            this.useColor(bps.color);
            this.writeln(bwidth3 + " setlinewidth");
            this.drawLine(startx + bwidth3 / 2.0f, starty, startx + bwidth3 / 2.0f, endy);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_AFTER)) != null) {
            float sy = starty + height;
            float endx = startx + width;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            bwidth = bps.width;
            this.useColor(bps.color);
            this.writeln(bwidth + " setlinewidth");
            this.drawLine(startx, sy - bwidth / 2.0f, endx, sy - bwidth / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_END)) != null) {
            float sx = startx + width;
            float endy = starty + height;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            bwidth = bps.width;
            this.useColor(bps.color);
            this.writeln(bwidth + " setlinewidth");
            this.drawLine(sx - bwidth / 2.0f, starty, sx - bwidth / 2.0f, endy);
        }
        if (started) {
            this.beginTextObject();
            this.currentFontName = "";
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.writeln(startx + " " + starty + " M ");
        this.writeln(endx + " " + endy + " lineto");
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(this, MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("psGenerator", this.gen);
        context.setProperty("psFontInfo", this.fontInfo);
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        context.setProperty("xpos", new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        this.renderXML(context, doc, ns);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }
}

