/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IBorderAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfExternalGraphicContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfTableCell
extends RtfContainer
implements IRtfParagraphContainer,
IRtfListContainer,
IRtfTableContainer,
IRtfExternalGraphicContainer,
IRtfTextrunContainer {
    private RtfParagraph paragraph;
    private RtfList list;
    private RtfTable table;
    private RtfExternalGraphic externalGraphic;
    private final RtfTableRow parentRow;
    private boolean setCenter;
    private boolean setRight;
    private int id;
    public static final int DEFAULT_CELL_WIDTH = 2000;
    private int cellWidth;
    private int widthOffset;
    private int vMerge = 0;
    private int hMerge = 0;
    public static final int NO_MERGE = 0;
    public static final int MERGE_START = 1;
    public static final int MERGE_WITH_PREVIOUS = 2;

    RtfTableCell(RtfTableRow parent, Writer w, int cellWidth, int idNum) throws IOException {
        super(parent, w);
        this.id = idNum;
        this.parentRow = parent;
        this.cellWidth = cellWidth;
        this.setCenter = false;
        this.setRight = false;
    }

    RtfTableCell(RtfTableRow parent, Writer w, int cellWidth, RtfAttributes attrs, int idNum) throws IOException {
        super(parent, w, attrs);
        this.id = idNum;
        this.parentRow = parent;
        this.cellWidth = cellWidth;
        if (attrs.getValue("number-columns-spanned") != null) {
            this.setHMerge(1);
            int nbMergedCells = (Integer)attrs.getValue("number-columns-spanned");
            if (parent.parent instanceof RtfTable) {
                ITableColumnsInfo tableColumnsInfo = ((RtfTable)parent.parent).getITableColumnsInfo();
                tableColumnsInfo.selectFirstColumn();
                while (this.id - 1 != tableColumnsInfo.getColumnIndex()) {
                    tableColumnsInfo.selectNextColumn();
                }
                for (int i = nbMergedCells - 1; i > 0; --i) {
                    tableColumnsInfo.selectNextColumn();
                    parent.newTableCellMergedHorizontally((int)tableColumnsInfo.getColumnWidth(), attrs);
                }
            }
        }
    }

    public RtfParagraph newParagraph(RtfAttributes attrs) throws IOException {
        this.closeAll();
        if (attrs == null) {
            attrs = new RtfAttributes();
        }
        attrs.set("intbl");
        this.paragraph = new RtfParagraph(this, this.writer, attrs);
        if (this.paragraph.attrib.isSet("qc")) {
            this.setCenter = true;
            attrs.set("qc");
        } else if (this.paragraph.attrib.isSet("qr")) {
            this.setRight = true;
            attrs.set("qr");
        } else {
            attrs.set("ql");
        }
        attrs.set("intbl");
        return this.paragraph;
    }

    public RtfExternalGraphic newImage() throws IOException {
        this.closeAll();
        this.externalGraphic = new RtfExternalGraphic(this, this.writer);
        return this.externalGraphic;
    }

    public RtfParagraph newParagraph() throws IOException {
        return this.newParagraph(null);
    }

    public RtfList newList(RtfAttributes attrib) throws IOException {
        this.closeAll();
        this.list = new RtfList(this, this.writer, attrib);
        return this.list;
    }

    public RtfTable newTable(ITableColumnsInfo tc) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, tc);
        return this.table;
    }

    public RtfTable newTable(RtfAttributes attrs, ITableColumnsInfo tc) throws IOException {
        this.closeAll();
        this.table = new RtfTable(this, this.writer, attrs, tc);
        return this.table;
    }

    int writeCellDef(int widthOffset) throws IOException {
        this.newLine();
        this.widthOffset = widthOffset;
        if (this.vMerge == 1) {
            this.writeControlWord("clvmgf");
        } else if (this.vMerge == 2) {
            this.writeControlWord("clvmrg");
        }
        if (this.hMerge == 1) {
            this.writeControlWord("clmgf");
        } else if (this.hMerge == 2) {
            this.writeControlWord("clmrg");
        }
        this.writeAttributes(this.attrib, ITableAttributes.CELL_COLOR);
        this.writeAttributes(this.attrib, ITableAttributes.ATTRIB_CELL_PADDING);
        this.writeAttributes(this.attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.attrib, IBorderAttributes.BORDERS);
        int xPos = widthOffset + this.cellWidth;
        if (this.setCenter) {
            this.writeControlWord("qc");
        } else if (this.setRight) {
            this.writeControlWord("qr");
        } else {
            this.writeControlWord("ql");
        }
        this.writeControlWord("cellx" + xPos);
        this.writeControlWord("ql");
        return xPos;
    }

    protected void writeRtfSuffix() throws IOException {
        if (this.setCenter) {
            this.writeControlWord("qc");
        } else if (this.setRight) {
            this.writeControlWord("qr");
        } else {
            this.writeControlWord("ql");
        }
        if (!this.containsText()) {
            this.writeControlWord("intbl");
        }
        this.writeControlWord("cell");
    }

    private void closeCurrentParagraph() throws IOException {
        if (this.paragraph != null) {
            this.paragraph.close();
        }
    }

    private void closeCurrentList() throws IOException {
        if (this.list != null) {
            this.list.close();
        }
    }

    private void closeCurrentTable() throws IOException {
        if (this.table != null) {
            this.table.close();
        }
    }

    private void closeCurrentExternalGraphic() throws IOException {
        if (this.externalGraphic != null) {
            this.externalGraphic.close();
        }
    }

    private void closeAll() throws IOException {
        this.closeCurrentTable();
        this.closeCurrentParagraph();
        this.closeCurrentList();
        this.closeCurrentExternalGraphic();
    }

    public void setVMerge(int mergeStatus) {
        this.vMerge = mergeStatus;
    }

    public int getVMerge() {
        return this.vMerge;
    }

    public void setHMerge(int mergeStatus) {
        this.hMerge = mergeStatus;
    }

    public int getHMerge() {
        return this.hMerge;
    }

    int getCellWidth() {
        return this.cellWidth;
    }

    protected void writeRtfContent() throws IOException {
        int extraRowIndex = 0;
        RtfContainer extraCell = null;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            RtfElement e = (RtfElement)it.next();
            if (e instanceof RtfTable) {
                this.parentRow.getExtraRowSet().setParentITableColumnsInfo(((RtfTable)this.getParentOfClass(e.getClass())).getITableColumnsInfo());
                extraRowIndex = this.parentRow.getExtraRowSet().addTable((RtfTable)e, extraRowIndex, this.widthOffset);
                extraCell = this.parentRow.getExtraRowSet().createExtraCell(extraRowIndex, this.widthOffset, this.getCellWidth(), this.attrib);
                ++extraRowIndex;
                continue;
            }
            if (extraCell != null) {
                extraCell.addChild(e);
                continue;
            }
            e.writeRtf();
        }
    }

    public boolean isEmpty() {
        return false;
    }

    boolean paragraphNeedsPar(RtfParagraph p) {
        boolean pFound = false;
        boolean result = false;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!pFound) {
                pFound = o == p;
                continue;
            }
            if (o instanceof RtfParagraph) {
                RtfParagraph p2 = (RtfParagraph)o;
                if (p2.isEmpty()) continue;
                result = true;
                break;
            }
            if (!(o instanceof RtfTable)) continue;
            break;
        }
        return result;
    }

    public RtfTextrun getTextrun() throws IOException {
        RtfAttributes attrs = new RtfAttributes();
        attrs.set("intbl");
        RtfTextrun textrun = RtfTextrun.getTextrun(this, this.writer, attrs);
        textrun.setSuppressLastPar(true);
        return textrun;
    }
}

