/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.rmi.DataBufferProxy;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

public class LookupTableJAI
implements Serializable {
    transient DataBuffer data;

    public LookupTableJAI(byte[] byArray) {
        this.data = new DataBufferByte(byArray, byArray.length);
    }

    public LookupTableJAI(byte[] byArray, int n) {
        this.data = new DataBufferByte(byArray, byArray.length, -n);
    }

    public LookupTableJAI(double[] dArray) {
        this.data = new DataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[] dArray, int n) {
        this.data = new DataBufferDouble(dArray, dArray.length, -n);
    }

    public LookupTableJAI(float[] fArray) {
        this.data = new DataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[] fArray, int n) {
        this.data = new DataBufferFloat(fArray, fArray.length, -n);
    }

    public LookupTableJAI(int[] nArray) {
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[] nArray, int n) {
        this.data = new DataBufferInt(nArray, nArray.length, -n);
    }

    public LookupTableJAI(short[] sArray, int n, boolean bl) {
        this.data = bl ? new DataBufferUShort(sArray, sArray.length, -n) : new DataBufferShort(sArray, sArray.length, -n);
    }

    public LookupTableJAI(short[] sArray, boolean bl) {
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(byte[][] byArray) {
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int n) {
        int[] nArray = new int[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            nArray[n2] = -n;
            ++n2;
        }
        this.data = new DataBufferByte(byArray, byArray[0].length, nArray);
    }

    public LookupTableJAI(byte[][] byArray, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = -nArray[n];
            ++n;
        }
        this.data = new DataBufferByte(byArray, byArray[0].length, nArray2);
    }

    public LookupTableJAI(double[][] dArray) {
        this.data = new DataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int n) {
        int[] nArray = new int[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            nArray[n2] = -n;
            ++n2;
        }
        this.data = new DataBufferDouble(dArray, dArray[0].length, nArray);
    }

    public LookupTableJAI(double[][] dArray, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = -nArray[n];
            ++n;
        }
        this.data = new DataBufferDouble(dArray, dArray[0].length, nArray2);
    }

    public LookupTableJAI(float[][] fArray) {
        this.data = new DataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int n) {
        int[] nArray = new int[fArray.length];
        int n2 = 0;
        while (n2 < fArray.length) {
            nArray[n2] = -n;
            ++n2;
        }
        this.data = new DataBufferFloat(fArray, fArray[0].length, nArray);
    }

    public LookupTableJAI(float[][] fArray, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = -nArray[n];
            ++n;
        }
        this.data = new DataBufferFloat(fArray, fArray[0].length, nArray2);
    }

    public LookupTableJAI(int[][] nArray) {
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = -n;
            ++n2;
        }
        this.data = new DataBufferInt(nArray, nArray[0].length, nArray2);
    }

    public LookupTableJAI(int[][] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        int n = 0;
        while (n < nArray2.length) {
            nArray3[n] = -nArray2[n];
            ++n;
        }
        this.data = new DataBufferInt(nArray, nArray[0].length, nArray3);
    }

    public LookupTableJAI(short[][] sArray, int n, boolean bl) {
        int[] nArray = new int[sArray.length];
        int n2 = 0;
        while (n2 < sArray.length) {
            nArray[n2] = -n;
            ++n2;
        }
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length, nArray) : new DataBufferShort(sArray, sArray[0].length, nArray);
    }

    public LookupTableJAI(short[][] sArray, boolean bl) {
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int[] nArray, boolean bl) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = -nArray[n];
            ++n;
        }
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length, nArray2) : new DataBufferShort(sArray, sArray[0].length, nArray2);
    }

    public int findNearestEntry(float[] fArray) {
        int n = this.data.getDataType();
        int n2 = this.getNumBands();
        int n3 = this.getNumEntries();
        int n4 = -1;
        if (n == 0) {
            byte[][] byArray = this.getByteData();
            float f = 0.0f;
            n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                float f2 = fArray[n5] - (float)(byArray[n5][0] & 0xFF);
                f += f2 * f2;
                ++n5;
            }
            int n6 = 1;
            while (n6 < n3) {
                float f3 = 0.0f;
                int n7 = 0;
                while (n7 < n2) {
                    float f4 = fArray[n7] - (float)(byArray[n7][n6] & 0xFF);
                    f3 += f4 * f4;
                    ++n7;
                }
                if (f3 < f) {
                    f = f3;
                    n4 = n6;
                }
                ++n6;
            }
        } else if (n == 2) {
            short[][] sArray = this.getShortData();
            float f = 0.0f;
            n4 = 0;
            int n8 = 0;
            while (n8 < n2) {
                float f5 = fArray[n8] - (float)sArray[n8][0];
                f += f5 * f5;
                ++n8;
            }
            int n9 = 1;
            while (n9 < n3) {
                float f6 = 0.0f;
                int n10 = 0;
                while (n10 < n2) {
                    float f7 = fArray[n10] - (float)sArray[n10][n9];
                    f6 += f7 * f7;
                    ++n10;
                }
                if (f6 < f) {
                    f = f6;
                    n4 = n9;
                }
                ++n9;
            }
        } else if (n == 1) {
            short[][] sArray = this.getShortData();
            float f = 0.0f;
            n4 = 0;
            int n11 = 0;
            while (n11 < n2) {
                float f8 = fArray[n11] - (float)(sArray[n11][0] & 0xFFFF);
                f += f8 * f8;
                ++n11;
            }
            int n12 = 1;
            while (n12 < n3) {
                float f9 = 0.0f;
                int n13 = 0;
                while (n13 < n2) {
                    float f10 = fArray[n13] - (float)(sArray[n13][n12] & 0xFFFF);
                    f9 += f10 * f10;
                    ++n13;
                }
                if (f9 < f) {
                    f = f9;
                    n4 = n12;
                }
                ++n12;
            }
        } else if (n == 3) {
            int[][] nArray = this.getIntData();
            float f = 0.0f;
            n4 = 0;
            int n14 = 0;
            while (n14 < n2) {
                float f11 = fArray[n14] - (float)nArray[n14][0];
                f += f11 * f11;
                ++n14;
            }
            int n15 = 1;
            while (n15 < n3) {
                float f12 = 0.0f;
                int n16 = 0;
                while (n16 < n2) {
                    float f13 = fArray[n16] - (float)nArray[n16][n15];
                    f12 += f13 * f13;
                    ++n16;
                }
                if (f12 < f) {
                    f = f12;
                    n4 = n15;
                }
                ++n15;
            }
        } else if (n == 4) {
            float[][] fArray2 = this.getFloatData();
            float f = 0.0f;
            n4 = 0;
            int n17 = 0;
            while (n17 < n2) {
                float f14 = fArray[n17] - fArray2[n17][0];
                f += f14 * f14;
                ++n17;
            }
            int n18 = 1;
            while (n18 < n3) {
                float f15 = 0.0f;
                int n19 = 0;
                while (n19 < n2) {
                    float f16 = fArray[n19] - fArray2[n19][n18];
                    f15 += f16 * f16;
                    ++n19;
                }
                if (f15 < f) {
                    f = f15;
                    n4 = n18;
                }
                ++n18;
            }
        } else if (n == 5) {
            double[][] dArray = this.getDoubleData();
            double d = 0.0;
            n4 = 0;
            int n20 = 0;
            while (n20 < n2) {
                double d2 = (double)fArray[n20] - dArray[n20][0];
                d += d2 * d2;
                ++n20;
            }
            int n21 = 1;
            while (n21 < n3) {
                double d3 = 0.0;
                int n22 = 0;
                while (n22 < n2) {
                    double d4 = (double)fArray[n22] - dArray[n22][n21];
                    d3 += d4 * d4;
                    ++n22;
                }
                if (d3 < d) {
                    d = d3;
                    n4 = n21;
                }
                ++n21;
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("LookupTableJAI0"));
        }
        return n4 == -1 ? n4 : n4 + this.getOffset();
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : null;
    }

    public byte[] getByteData(int n) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(n) : null;
    }

    public DataBuffer getData() {
        return this.data;
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int n) {
        int n2 = this.getNumBands();
        return n == 1 ? n2 : n;
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel) {
        return this.getDestSampleModel(sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel, int n, int n2) {
        if (!this.isIntegralDataType(sampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel(sampleModel, this.getDataType(), n, n2, this.getDestNumBands(sampleModel.getNumBands()));
    }

    public double[][] getDoubleData() {
        return this.data instanceof DataBufferDouble ? ((DataBufferDouble)this.data).getBankData() : null;
    }

    public double[] getDoubleData(int n) {
        return this.data instanceof DataBufferDouble ? ((DataBufferDouble)this.data).getData(n) : null;
    }

    public float[][] getFloatData() {
        return this.data instanceof DataBufferFloat ? ((DataBufferFloat)this.data).getBankData() : null;
    }

    public float[] getFloatData(int n) {
        return this.data instanceof DataBufferFloat ? ((DataBufferFloat)this.data).getData(n) : null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : null;
    }

    public int[] getIntData(int n) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(n) : null;
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getOffset() {
        return -this.data.getOffset();
    }

    public int getOffset(int n) {
        int[] nArray = this.data.getOffsets();
        return -nArray[n];
    }

    public int[] getOffsets() {
        int[] nArray = this.data.getOffsets();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = -nArray[n];
            ++n;
        }
        return nArray2;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int n) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(n);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(n);
        }
        return null;
    }

    public boolean isIntegralDataType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3;
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public int lookup(int n, int n2) {
        return this.data.getElem(n, n2);
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray2, int[] nArray3, byte[][] byArray3) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray4 = byArray[n8];
            byte[] byArray5 = byArray2[n8];
            byte[] byArray6 = byArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray5[n14] = byArray6[(byArray4[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                byte[] byArray2 = byArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, byArray2[n12] & 0xFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                byte[] byArray3 = byArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(byArray3[n20] & 0xFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray, int[] nArray3, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, byte[][] byArray, int[] nArray4, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, double[][] dArray, int[] nArray4, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, float[][] fArray, int[] nArray4, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, int[][] nArray4, int[] nArray5, int[][] nArray6) {
        if (nArray6 == null) {
            int n8 = 0;
            while (n8 < n5) {
                int[] nArray7 = nArray2[n8];
                int[] nArray8 = nArray4[n8];
                int n9 = nArray[n8];
                int n10 = nArray3[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray8[n13] = this.data.getElem(n8, nArray7[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                int[] nArray9 = nArray2[n15];
                int[] nArray10 = nArray4[n15];
                int[] nArray11 = nArray6[n15];
                int n16 = nArray[n15];
                int n17 = nArray3[n15];
                int n18 = nArray5[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray10[n21] = nArray11[nArray9[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, short[][] sArray, int[] nArray4, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[sArray3[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[sArray4[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public WritableRaster lookup(Raster var1_1, WritableRaster var2_2, Rectangle var3_3) {
        if (var1_1 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI1"));
        }
        var4_4 = var1_1.getSampleModel();
        if (!this.isIntegralDataType(var4_4)) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI2"));
        }
        var3_3 = var3_3 == null ? var1_1.getBounds() : var3_3.intersection(var1_1.getBounds());
        if (var2_2 != null) {
            var3_3 = var3_3.intersection(var2_2.getBounds());
        }
        if (var2_2 == null) {
            var5_5 = this.getDestSampleModel(var4_4, var3_3.width, var3_3.height);
            var2_2 = RasterFactory.createWritableRaster(var5_5, new Point(var3_3.x, var3_3.y));
        } else {
            var5_5 = var2_2.getSampleModel();
            if (var5_5.getTransferType() != this.getDataType() || var5_5.getNumBands() != this.getDestNumBands(var4_4.getNumBands())) {
                throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI3"));
            }
        }
        var6_6 = RasterAccessor.findCompatibleTag(null, var4_4);
        var7_7 = RasterAccessor.findCompatibleTag(null, var5_5);
        var8_8 = new RasterFormatTag(var4_4, var6_6);
        var9_9 = new RasterFormatTag(var5_5, var7_7);
        var10_10 = new RasterAccessor(var1_1, var3_3, var8_8, null);
        var11_11 = new RasterAccessor(var2_2, var3_3, var9_9, null);
        var12_12 = var10_10.getNumBands();
        var13_13 = var10_10.getDataType();
        var14_14 = this.getNumBands();
        var15_15 = this.getDataType();
        var16_16 = var11_11.getWidth();
        var17_17 = var11_11.getHeight();
        var18_18 = var11_11.getNumBands();
        var19_19 = var11_11.getDataType();
        var20_20 = var10_10.getScanlineStride();
        var21_21 = var10_10.getPixelStride();
        var22_22 = var10_10.getBandOffsets();
        var23_23 = var10_10.getByteDataArrays();
        var24_24 = var10_10.getShortDataArrays();
        var25_25 = var10_10.getIntDataArrays();
        if (var12_12 < var18_18) {
            var26_26 = var22_22[0];
            var22_22 = new int[var18_18];
            var27_28 = 0;
            while (var27_28 < var18_18) {
                var22_22[var27_28] = var26_26;
                ++var27_28;
            }
            switch (var13_13) {
                case 0: {
                    var28_30 /* !! */  = (short[][])var23_23[0];
                    var23_23 = new byte[var18_18][];
                    var29_31 = 0;
                    while (var29_31 < var18_18) {
                        var23_23[var29_31] = (byte[])var28_30 /* !! */ ;
                        ++var29_31;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    var29_32 = var24_24[0];
                    var24_24 = new short[var18_18][];
                    var30_34 = 0;
                    while (var30_34 < var18_18) {
                        var24_24[var30_34] = var29_32;
                        ++var30_34;
                    }
                    break;
                }
                case 3: {
                    var30_35 = var25_25[0];
                    var25_25 = new int[var18_18][];
                    var31_37 = 0;
                    while (var31_37 < var18_18) {
                        var25_25[var31_37] = var30_35;
                        ++var31_37;
                    }
                    break;
                }
            }
        }
        var26_27 = this.getOffsets();
        var27_29 = this.getByteData();
        var28_30 /* !! */  = this.getShortData();
        var29_33 = this.getIntData();
        var30_36 = this.getFloatData();
        var31_38 = this.getDoubleData();
        if (var14_14 < var18_18) {
            var32_39 = var26_27[0];
            var26_27 = new int[var18_18];
            var33_40 = 0;
            while (var33_40 < var18_18) {
                var26_27[var33_40] = var32_39;
                ++var33_40;
            }
            switch (var15_15) {
                case 0: {
                    var34_41 /* !! */  = var27_29[0];
                    var27_29 = new byte[var18_18][];
                    var35_42 = 0;
                    while (var35_42 < var18_18) {
                        var27_29[var35_42] = (byte[])var34_41 /* !! */ ;
                        ++var35_42;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    var35_43 = var28_30 /* !! */ [0];
                    var28_30 /* !! */  = new short[var18_18][];
                    var36_45 = 0;
                    while (var36_45 < var18_18) {
                        var28_30 /* !! */ [var36_45] = var35_43;
                        ++var36_45;
                    }
                    break;
                }
                case 3: {
                    var36_46 = var29_33[0];
                    var29_33 = new int[var18_18][];
                    var37_48 = 0;
                    while (var37_48 < var18_18) {
                        var29_33[var37_48] = var36_46;
                        ++var37_48;
                    }
                    break;
                }
                case 4: {
                    var37_49 = var30_36[0];
                    var30_36 = new float[var18_18][];
                    var38_51 = 0;
                    while (var38_51 < var18_18) {
                        var30_36[var38_51] = var37_49;
                        ++var38_51;
                    }
                    break;
                }
                case 5: {
                    var38_52 = var31_38[0];
                    var31_38 = new double[var18_18][];
                    var39_54 = 0;
                    while (var39_54 < var18_18) {
                        var31_38[var39_54] = var38_52;
                        ++var39_54;
                    }
                    break;
                }
            }
        }
        var32_39 = var11_11.getScanlineStride();
        var33_40 = var11_11.getPixelStride();
        var34_41 /* !! */  = var11_11.getBandOffsets();
        var35_44 = var11_11.getByteDataArrays();
        var36_47 = var11_11.getShortDataArrays();
        var37_50 = var11_11.getIntDataArrays();
        var38_53 = var11_11.getFloatDataArrays();
        var39_55 = var11_11.getDoubleDataArrays();
        block12 : switch (var19_19) {
            case 0: {
                switch (var13_13) {
                    case 0: {
                        this.lookup(var20_20, var21_21, var22_22, var23_23, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var35_44, var26_27, var27_29);
                        ** break;
                    }
                    case 1: {
                        this.lookupU(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var35_44, var26_27, var27_29);
                        ** break;
                    }
                    case 2: {
                        this.lookup(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var35_44, var26_27, var27_29);
                        ** break;
                    }
                    case 3: {
                        this.lookup(var20_20, var21_21, var22_22, var25_25, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var35_44, var26_27, var27_29);
                        ** break;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            case 1: 
            case 2: {
                switch (var13_13) {
                    case 0: {
                        this.lookup(var20_20, var21_21, var22_22, var23_23, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var36_47, var26_27, var28_30 /* !! */ );
                        ** break;
                    }
                    case 1: {
                        this.lookupU(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var36_47, var26_27, var28_30 /* !! */ );
                        ** break;
                    }
                    case 2: {
                        this.lookup(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var36_47, var26_27, var28_30 /* !! */ );
                        ** break;
                    }
                    case 3: {
                        this.lookup(var20_20, var21_21, var22_22, var25_25, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var36_47, var26_27, var28_30 /* !! */ );
                        ** break;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            case 3: {
                switch (var13_13) {
                    case 0: {
                        this.lookup(var20_20, var21_21, var22_22, var23_23, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var37_50, var26_27, var29_33);
                        ** break;
                    }
                    case 1: {
                        this.lookupU(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var37_50, var26_27, var29_33);
                        ** break;
                    }
                    case 2: {
                        this.lookup(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var37_50, var26_27, var29_33);
                        ** break;
                    }
                    case 3: {
                        this.lookup(var20_20, var21_21, var22_22, var25_25, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var37_50, var26_27, var29_33);
                        ** break;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            case 4: {
                switch (var13_13) {
                    case 0: {
                        this.lookup(var20_20, var21_21, var22_22, var23_23, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var38_53, var26_27, var30_36);
                        ** break;
                    }
                    case 1: {
                        this.lookupU(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var38_53, var26_27, var30_36);
                        ** break;
                    }
                    case 2: {
                        this.lookup(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var38_53, var26_27, var30_36);
                        ** break;
                    }
                    case 3: {
                        this.lookup(var20_20, var21_21, var22_22, var25_25, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var38_53, var26_27, var30_36);
                        ** break;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            case 5: {
                switch (var13_13) {
                    case 0: {
                        this.lookup(var20_20, var21_21, var22_22, var23_23, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var39_55, var26_27, var31_38);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var39_55, var26_27, var31_38);
                        break block12;
                    }
                    case 2: {
                        this.lookup(var20_20, var21_21, var22_22, var24_24, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var39_55, var26_27, var31_38);
                        break block12;
                    }
                    case 3: {
                        this.lookup(var20_20, var21_21, var22_22, var25_25, var16_16, var17_17, var18_18, var32_39, var33_40, var34_41 /* !! */ , var39_55, var26_27, var31_38);
                        break block12;
                    }
                }
            }
lbl220:
            // 16 sources

            break;
        }
        var11_11.copyDataToRaster();
        return var2_2;
    }

    public WritableRaster lookup(WritableRaster writableRaster) {
        return this.lookup(writableRaster, writableRaster, writableRaster.getBounds());
    }

    public double lookupDouble(int n, int n2) {
        return this.data.getElemDouble(n, n2);
    }

    public float lookupFloat(int n, int n2) {
        return this.data.getElemFloat(n, n2);
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12] & 0xFFFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(sArray3[n20] & 0xFFFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[(sArray4[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        DataBufferProxy dataBufferProxy = (DataBufferProxy)objectInputStream.readObject();
        this.data = dataBufferProxy.getDataBuffer();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataBufferProxy dataBufferProxy = new DataBufferProxy(this.data);
        objectOutputStream.writeObject(dataBufferProxy);
    }
}

