/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class PartialOrderNode
implements Cloneable,
Serializable {
    protected String name;
    protected Object nodeData;
    protected int inDegree = 0;
    protected int copyInDegree = 0;
    protected PartialOrderNode zeroLink = null;
    Vector neighbors = new Vector();

    public PartialOrderNode(Object object, String string) {
        this.nodeData = object;
        this.name = string;
    }

    public void addEdge(PartialOrderNode partialOrderNode) {
        this.neighbors.addElement(partialOrderNode);
        partialOrderNode.incrementInDegree();
    }

    public void decrementCopyInDegree() {
        --this.copyInDegree;
    }

    public void decrementInDegree() {
        --this.inDegree;
    }

    public int getCopyInDegree() {
        return this.copyInDegree;
    }

    public Object getData() {
        return this.nodeData;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration getNeighbors() {
        return this.neighbors.elements();
    }

    public PartialOrderNode getZeroLink() {
        return this.zeroLink;
    }

    public void incrementCopyInDegree() {
        ++this.copyInDegree;
    }

    public void incrementInDegree() {
        ++this.inDegree;
    }

    public void removeEdge(PartialOrderNode partialOrderNode) {
        this.neighbors.removeElement(partialOrderNode);
        partialOrderNode.decrementInDegree();
    }

    public void setCopyInDegree(int n) {
        this.copyInDegree = n;
    }

    public void setZeroLink(PartialOrderNode partialOrderNode) {
        this.zeroLink = partialOrderNode;
    }
}

