/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.service.resolver.VersionRange;

public class RequiredCapability {
    private static final String[] NO_SELECTORS = new String[0];
    private String filter;
    private final boolean multiple;
    private final String name;
    private final String namespace;
    private boolean optional;
    private boolean greedy = true;
    private final VersionRange range;
    private String[] selectors = NO_SELECTORS;

    RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.namespace = namespace;
        this.name = name;
        this.range = range == null ? VersionRange.emptyRange : range;
        this.optional = optional;
        this.filter = filter;
        this.multiple = multiple;
    }

    RequiredCapability(String namespace, String name, VersionRange range, String filter, boolean optional, boolean multiple, boolean greedy) {
        this(namespace, name, range, filter, optional, multiple);
        this.greedy = greedy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequiredCapability other = (RequiredCapability)obj;
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.multiple != other.multiple) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.optional != other.optional) {
            return false;
        }
        return this.range.equals((Object)other.range);
    }

    public String getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public String[] getSelectors() {
        return this.selectors;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.multiple ? 1231 : 1237);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + this.range.hashCode();
        return result;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectors(String[] selectors) {
        this.selectors = selectors;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public String toString() {
        return "requiredCapability: " + this.namespace + '/' + this.name + '/' + this.range;
    }
}

