/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core.helpers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.helpers.Messages;
import org.eclipse.osgi.util.NLS;

public class FileUtils {
    public static File[] unzipFile(File zipFile, File outputDir) throws IOException {
        FileInputStream in = new FileInputStream(zipFile);
        try {
            File[] fileArray = FileUtils.unzipStream(in, zipFile.length(), outputDir, null, null);
            return fileArray;
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()));
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static File[] unzipFile(File zipFile, File outputDir, String taskName, IProgressMonitor monitor) throws IOException {
        FileInputStream in = new FileInputStream(zipFile);
        try {
            File[] fileArray = FileUtils.unzipStream(in, zipFile.length(), outputDir, taskName, monitor);
            return fileArray;
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)e.getMessage()));
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static File[] unzipURL(URL zipURL, File outputDir, String taskName, IProgressMonitor monitor) throws IOException {
        int size = zipURL.openConnection().getContentLength();
        InputStream in = zipURL.openStream();
        try {
            File[] fileArray = FileUtils.unzipStream(in, size, outputDir, taskName, monitor);
            return fileArray;
        }
        catch (IOException e) {
            throw new IOException(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipURL, (Object)e.getMessage()));
        }
        finally {
            in.close();
        }
    }

    public static File[] unzipStream(InputStream stream, long size, File outputDir, String taskName, IProgressMonitor monitor) throws IOException {
        InputStream is = monitor == null ? stream : stream;
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(is));
        ZipEntry ze = in.getNextEntry();
        if (ze == null) {
            in.close();
            throw new IOException(Messages.Util_Invalid_Zip_File_Format);
        }
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        do {
            File outFile = new File(outputDir, ze.getName());
            unzippedFiles.add(outFile);
            if (ze.isDirectory()) {
                outFile.mkdirs();
            } else {
                if (outFile.exists()) {
                    outFile.delete();
                } else {
                    outFile.getParentFile().mkdirs();
                }
                try {
                    FileUtils.copyStream(in, false, new FileOutputStream(outFile), true);
                }
                catch (FileNotFoundException fileNotFoundException) {}
                outFile.setLastModified(ze.getTime());
            }
            in.closeEntry();
        } while ((ze = in.getNextEntry()) != null);
        in.close();
        return unzippedFiles.toArray(new File[unzippedFiles.size()]);
    }

    public static void deleteEmptyDirs(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                FileUtils.deleteEmptyDirs(files[i]);
                ++i;
            }
            dir.getCanonicalFile().delete();
        }
    }

    public static void deleteAll(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                FileUtils.deleteAll(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static void zip(File[] sourceFiles, File destinationArchive) throws IOException {
        FileUtils.zip(sourceFiles, destinationArchive, true);
    }

    public static void zip(File[] sourceFiles, File destinationArchive, boolean includeRoot) throws IOException {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destinationArchive));
        try {
            int i = 0;
            while (i < sourceFiles.length) {
                if (sourceFiles[i].isDirectory()) {
                    FileUtils.zipDir(output, sourceFiles[i], (IPath)(includeRoot ? new Path(sourceFiles[i].getName()) : new Path("")));
                } else {
                    FileUtils.zipFile(output, sourceFiles[i], (IPath)new Path(""));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {}
    }

    private static void zipDir(ZipOutputStream output, File source, IPath prefix) {
        File[] files = source.listFiles();
        int i = 0;
        while (i < files.length) {
            try {
                if (files[i].isFile()) {
                    FileUtils.zipFile(output, files[i], prefix);
                } else {
                    FileUtils.zipDir(output, files[i], prefix.append(files[i].getName()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static void zipFile(ZipOutputStream output, File sourceFile, IPath prefix) throws IOException {
        FileInputStream input = new FileInputStream(sourceFile);
        try {
            ZipEntry zipEntry = new ZipEntry(prefix.append(sourceFile.getName()).toString());
            zipEntry.setTime(sourceFile.lastModified());
            output.putNextEntry(zipEntry);
            FileUtils.copyStream(input, true, output, false);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
            try {
                output.closeEntry();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)input).close();
        }
        catch (IOException iOException) {}
        try {
            output.closeEntry();
        }
        catch (IOException iOException) {}
    }
}

