/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.model.QueriedElementCollector;
import org.eclipse.equinox.internal.provisional.p2.ui.model.UncategorizedCategoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.query.ElementQueryDescriptor;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryContext;
import org.osgi.framework.Version;

public class CategoryElementCollector
extends QueriedElementCollector {
    private boolean groupUncategorized;
    private Set referredIUs = new HashSet();

    public CategoryElementCollector(IQueryProvider queryProvider, IQueryable queryable, QueryContext queryContext, boolean showUncategorized) {
        super(queryProvider, queryable, queryContext);
        this.groupUncategorized = showUncategorized;
    }

    public boolean accept(Object match) {
        if (!(match instanceof IInstallableUnit)) {
            return true;
        }
        IInstallableUnit iu = (IInstallableUnit)match;
        RequiredCapability[] requirements = iu.getRequiredCapabilities();
        int i = 0;
        while (i < requirements.length) {
            if (requirements[i].getNamespace().equals("org.eclipse.equinox.p2.iu")) {
                this.referredIUs.add(requirements[i].getName());
            }
            ++i;
        }
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            CategoryElement element = (CategoryElement)iter.next();
            if (!element.getIU().getId().equals(iu.getId())) continue;
            element.mergeIU(iu);
            return true;
        }
        return super.accept(new CategoryElement(iu));
    }

    private void cleanList() {
        if (this.groupUncategorized) {
            this.createDummyCategory();
        }
        this.removeNestedCategories();
    }

    public Iterator iterator() {
        this.cleanList();
        return super.iterator();
    }

    public Object[] toArray(Class clazz) {
        this.cleanList();
        return super.toArray(clazz);
    }

    public Collection toCollection() {
        this.cleanList();
        return super.toCollection();
    }

    public int size() {
        this.cleanList();
        return super.size();
    }

    public boolean isEmpty() {
        this.cleanList();
        return super.isEmpty();
    }

    private void createDummyCategory() {
        MetadataFactory.InstallableUnitDescription unit = new MetadataFactory.InstallableUnitDescription();
        unit.setId(ProvUIMessages.CategoryElementCollector_Uncategorized);
        unit.setProperty("org.eclipse.equinox.p2.type.category", Boolean.toString(true));
        unit.setVersion(new Version(0, 0, 0, "generated"));
        unit.setProperty("org.eclipse.equinox.p2.name", ProvUIMessages.CategoryElementCollector_Uncategorized);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)unit);
        UncategorizedCategoryElement element = new UncategorizedCategoryElement(iu);
        element.setQueryable(this.queryable);
        element.setQueryProvider(this.queryProvider);
        element.setQueryContext(this.queryContext);
        ElementQueryDescriptor queryDescriptor = this.queryProvider.getQueryDescriptor(element, element.getQueryType());
        Collector collector = queryDescriptor.queryable.query(queryDescriptor.query, queryDescriptor.collector, null);
        if (!collector.isEmpty()) {
            this.getList().add(element);
        }
    }

    private void removeNestedCategories() {
        CategoryElement[] categoryIUs = this.getList().toArray(new CategoryElement[this.getList().size()]);
        int i = 0;
        while (i < categoryIUs.length) {
            if (this.referredIUs.contains(categoryIUs[i].getIU().getId())) {
                this.getList().remove(categoryIUs[i]);
            }
            ++i;
        }
    }
}

