/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xalan.lib.sql.XStatement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.traversal.NodeIterator;

public class XConnection {
    private static final boolean DEBUG = false;
    public String m_driver;
    public String m_dbURL;
    public String m_user;
    public String m_password;
    public Properties m_protocol;
    public Connection m_connection = null;

    public XConnection(String driver, String dbURL) {
        this.init(driver, dbURL, null, null, null, 1);
    }

    public XConnection(String driver, String dbURL, String user, String password) {
        this.init(driver, dbURL, user, password, null, 3);
    }

    public XConnection(String driver, String dbURL, Element protocolElem) {
        this.init(driver, dbURL, null, null, protocolElem, 2);
    }

    public void close() throws SQLException {
        if (this.m_connection != null) {
            this.m_connection.close();
            this.m_connection = null;
        }
    }

    public void connect(String driver, String dbURL, String user, String password, Properties protocol, int getConnectionArgs) {
        try {
            Class.forName(driver).newInstance();
            switch (getConnectionArgs) {
                case 1: {
                    this.m_connection = DriverManager.getConnection(dbURL);
                    break;
                }
                case 2: {
                    this.m_connection = DriverManager.getConnection(dbURL, protocol);
                    break;
                }
                case 3: {
                    this.m_connection = DriverManager.getConnection(dbURL, user, password);
                }
            }
            try {
                this.m_connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
            DatabaseMetaData dma = this.m_connection.getMetaData();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void init(String driver, String dbURL, String user, String password, Element protocolElem, int getConnectionArgs) {
        this.m_driver = driver;
        this.m_dbURL = dbURL;
        this.m_user = user;
        this.m_password = password;
        if (protocolElem == null) {
            this.m_protocol = null;
        } else {
            this.m_protocol = new Properties();
            NamedNodeMap atts = protocolElem.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                ((Hashtable)this.m_protocol).put(atts.item(i).getNodeName(), atts.item(i).getNodeValue());
                ++i;
            }
        }
        this.connect(driver, dbURL, user, password, this.m_protocol, getConnectionArgs);
    }

    public NodeIterator query(String queryString) throws SQLException {
        return new XStatement(this, queryString);
    }
}

