/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusOptionsManager;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.GraphColorsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SplusColorControl
extends SplusComboBox
implements SplusControlMethods {
    private String[] styleList;
    private static final int iconHeight = System.getProperty("os.name", "").toLowerCase().indexOf("windows") > -1 ? SplusControlMetrics.getLabelDimension().height - 6 : SplusControlMetrics.getLabelDimension().height - 8;
    private ColorScheme colorScheme = new ColorScheme();
    private LocalIcon[] iconList = null;

    public SplusColorControl() {
        super("Color", 'C', new String[0]);
        boolean bl;
        this.styleList = this.colorScheme.getPaletteColorLabels();
        super.setOptionList(this.styleList);
        this.setEditable(false);
        this.comboBox.setSelectedIndex(1);
        String string = SplusOptionsManager.getOption("new.graphsheet");
        boolean bl2 = bl = string.equals("") || string.equals("T") || string.equals("TRUE");
        if (bl) {
            this.colorScheme = GraphColorsDialog.getDefaultColorScheme();
        } else {
            SplusCanvasHandler splusCanvasHandler = SplusSystem.getCanvasHandler();
            if (splusCanvasHandler != null) {
                SCanvas sCanvas = splusCanvasHandler.getCurrentDeviceCanvas();
                this.colorScheme = sCanvas != null ? sCanvas.getColorScheme() : new ColorScheme();
            }
        }
        if (this.iconList == null) {
            this.iconList = new LocalIcon[this.styleList.length];
            for (int i = 0; i < this.iconList.length; ++i) {
                this.iconList[i] = new LocalIcon(i);
            }
        }
        this.comboBox.setRenderer(new LocalCellRenderer());
    }

    public synchronized String getValue() {
        int n = -1;
        try {
            n = this.comboBox.getSelectedIndex();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string = n == -1 ? "" : Integer.toString(n);
        return string;
    }

    public synchronized void setValue(String string) {
        int n = -1;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n != -1) {
            this.comboBox.setSelectedIndex(n);
        }
    }

    public synchronized String[] getOptionList() {
        return new String[0];
    }

    public synchronized void setOptionList(String[] stringArray) {
    }

    private class LocalIcon
    implements Icon {
        private int colorNumber;

        public LocalIcon(int n) {
            this.colorNumber = n;
        }

        public int getIconHeight() {
            return iconHeight;
        }

        public int getIconWidth() {
            return iconHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = this.colorNumber == 0 ? SplusColorControl.this.colorScheme.getBackgroundColor() : SplusColorControl.this.colorScheme.getPaletteColor(this.colorNumber);
            graphics.setColor(color);
            graphics.fillRect(3, 3, iconHeight - 6, iconHeight - 6);
            graphics.setColor(SystemColor.windowBorder);
            graphics.drawRect(2, 2, iconHeight - 5, iconHeight - 5);
        }
    }

    private class LocalCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocalCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = n;
            if (n2 == -1) {
                n2 = Math.max(SplusColorControl.this.comboBox.getSelectedIndex(), 0);
            }
            if (n2 < SplusColorControl.this.styleList.length) {
                this.setText(SplusColorControl.this.styleList[n2]);
                this.setIcon(SplusColorControl.this.iconList[n2]);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

