/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusLabelBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class SplusDoubleSpinner
extends SplusLabelBox
implements SplusControlMethods {
    JTextField textField;
    JScrollBar scrollBar;
    JLabel label;
    double minValue;
    double maxValue;
    double incrementValue;
    int numSteps;
    int lastStepValue;
    static int SCROLL_WIDTH = 15;

    public SplusDoubleSpinner(String string) {
        this(string, 0.0, 100.0, 1.0);
    }

    public SplusDoubleSpinner(String string, char c) {
        this(string, 0.0, 100.0, 1.0);
        this.setMnemonic(c);
    }

    public SplusDoubleSpinner(String string, int n) {
        this(string, 0.0, 100.0, 1.0);
        this.setMnemonic(n);
    }

    public SplusDoubleSpinner(String string, int n, double d, double d2, double d3) {
        this(string, d, d2, d3);
        this.setMnemonic(n);
    }

    public SplusDoubleSpinner(String string, char c, double d, double d2, double d3) {
        this(string, d, d2, d3);
        this.setMnemonic(c);
    }

    public SplusDoubleSpinner(String string, double d, double d2, double d3) {
        super(string);
        this.minValue = d;
        this.maxValue = d2;
        this.incrementValue = d3;
        this.lastStepValue = this.numSteps = (int)((d2 - d) / d3);
        Dimension dimension = SplusControlMetrics.getLabelDimension();
        Dimension dimension2 = SplusControlMetrics.getFullDimension();
        this.textField = new JTextField();
        this.textField.setPreferredSize(new Dimension(dimension.width - SCROLL_WIDTH, dimension.height));
        this.textField.setText(new Double(this.minValue).toString());
        this.scrollBar = new JScrollBar(1, this.lastStepValue, 0, 0, this.numSteps);
        this.scrollBar.setPreferredSize(new Dimension(SCROLL_WIDTH, dimension.height));
        this.scrollBar.addAdjustmentListener(new ScrollListener());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.textField, "Center");
        jPanel.add((Component)this.scrollBar, "East");
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        jPanel.setMaximumSize(dimension);
        this.setActionControl(jPanel);
        this.setLabelFor(this.textField);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setValue(String string) {
        this.textField.setText(string);
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] stringArray) {
    }

    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        this.scrollBar.setEnabled(bl);
        this.setLabelEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    private class TextListener
    implements ActionListener {
        private TextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SplusDoubleSpinner.this.setValue(SplusDoubleSpinner.this.textField.getText());
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            double d;
            try {
                d = Double.valueOf(SplusDoubleSpinner.this.textField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                d = SplusDoubleSpinner.this.minValue;
            }
            d += (double)(SplusDoubleSpinner.this.lastStepValue - adjustmentEvent.getValue()) * SplusDoubleSpinner.this.incrementValue;
            d = Math.max(Math.min(d, SplusDoubleSpinner.this.maxValue), SplusDoubleSpinner.this.minValue);
            SplusDoubleSpinner.this.textField.setText(new Double(d).toString());
            SplusDoubleSpinner.this.lastStepValue = adjustmentEvent.getValue();
        }
    }
}

