/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCustomLineAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;

class SGraphLinesAWT
extends SGraphCommand {
    float[] m_x;
    float[] m_y;
    int m_width;
    int m_dash;
    private transient int[] m_xpoints = null;
    private transient int[] m_ypoints = null;
    private transient SCustomLineAWT m_line = null;

    SGraphLinesAWT(float[] fArray, float[] fArray2, int n, int n2) {
        this.m_x = fArray;
        this.m_y = fArray2;
        this.m_width = n;
        this.m_dash = n2;
    }

    void graphSizeChanged() {
        this.m_xpoints = null;
        this.m_ypoints = null;
    }

    public void releaseMemory() {
        this.m_xpoints = null;
        this.m_ypoints = null;
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        if (this.m_line == null) {
            this.m_line = this.getCustomLine(sCanvasAWT);
        }
        if (this.m_xpoints == null) {
            int n = this.m_x.length;
            this.m_xpoints = new int[n];
            this.m_ypoints = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_xpoints[i] = this.valToWindowX(sCanvasAWT, this.m_x[i]);
                this.m_ypoints[i] = this.valToWindowY(sCanvasAWT, this.m_y[i]);
            }
        }
        Rectangle rectangle = this.setParClip(sCanvasAWT, graphics);
        this.setLineColor(sCanvasAWT, graphics);
        this.m_line.drawPolyline(graphics, this.m_xpoints, this.m_ypoints, this.m_xpoints.length);
        this.resetClip(sCanvasAWT, graphics, rectangle);
    }

    SCustomLineAWT getCustomLine(SCanvasAWT sCanvasAWT) {
        return new SCustomLineAWT(sCanvasAWT.getLineDashes(this.m_dash), this.m_width);
    }

    public String getXMLTag() {
        return "LINES";
    }

    public void writeXMLProperties(PrintWriter printWriter) {
        XML.writeProperty(printWriter, "WIDTH", this.m_width);
        XML.writeProperty(printWriter, "DASH", this.m_dash);
    }

    public void writeXMLContents(PrintWriter printWriter) {
        XML.writeData(printWriter, "X", this.m_x);
        XML.writeData(printWriter, "Y", this.m_y);
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        int n = XML.getIntProperty(xMLElement, "WIDTH", iDHash);
        int n2 = XML.getIntProperty(xMLElement, "DASH", iDHash);
        float[] fArray = XML.getFloatArrayData(xMLElement, "X");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y");
        return new SGraphLinesAWT(fArray, fArray2, n, n2);
    }
}

