/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;

class SplusDesktopManager
extends DefaultDesktopManager {
    Rectangle m_currentRect = null;

    SplusDesktopManager() {
    }

    void xorRect(JComponent jComponent) {
        if (this.m_currentRect != null) {
            JDesktopPane jDesktopPane = this.findTopDesktopPane(jComponent);
            if (jDesktopPane == null) {
                return;
            }
            Graphics graphics = jDesktopPane.getGraphics();
            graphics.setXORMode(Color.red);
            graphics.drawRect(this.m_currentRect.x, this.m_currentRect.y, this.m_currentRect.width, this.m_currentRect.height);
            graphics.setXORMode(Color.green);
            graphics.drawRect(this.m_currentRect.x + 1, this.m_currentRect.y + 1, this.m_currentRect.width, this.m_currentRect.height);
            graphics.setXORMode(Color.red);
            graphics.drawRect(this.m_currentRect.x + 2, this.m_currentRect.y + 2, this.m_currentRect.width, this.m_currentRect.height);
            graphics.setXORMode(Color.green);
            graphics.drawRect(this.m_currentRect.x + 3, this.m_currentRect.y + 3, this.m_currentRect.width, this.m_currentRect.height);
            graphics.setPaintMode();
        }
    }

    JDesktopPane findTopDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }

    public void beginDraggingFrame(JComponent jComponent) {
        this.m_currentRect = null;
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
        this.resizeFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
    }

    public void endDraggingFrame(JComponent jComponent) {
        this.endResizingFrame(jComponent);
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        this.m_currentRect = null;
    }

    public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.xorRect(jComponent);
        this.m_currentRect = new Rectangle(n, n2, n3, n4);
        this.xorRect(jComponent);
    }

    public void endResizingFrame(JComponent jComponent) {
        if (this.m_currentRect != null) {
            this.xorRect(jComponent);
            this.setBoundsForFrame(jComponent, this.m_currentRect.x, this.m_currentRect.y, this.m_currentRect.width, this.m_currentRect.height);
            this.m_currentRect = null;
        }
        jComponent.repaint();
    }
}

