/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusAltKeyListener;
import com.insightful.splus.client.ClientLoginHelpDialog;
import com.insightful.splus.client.SessionProfile;
import com.insightful.splus.client.SessionProfileList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class EditSessionProfileDialog
extends JDialog {
    SplusWideTextField sessionName;
    SplusWideTextField serverName;
    SplusWideTextField userName;
    SplusWideTextField cwdName;
    SplusWideTextField xserverDisplay;
    SplusButton advancedButton;
    String helpOffValue;
    String helpHostValue;
    String serverRmiportValue;
    String serverPromptValue;
    String serverTelnetScriptValue;
    JPanel buttonPanel;
    JPanel centerPanel;
    SplusGroupPanel nameGroup;
    SplusGroupPanel userGroup;
    SplusGroupPanel serverGroup;
    SplusGroupPanel xserverGroup;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    JButton removeButton;
    ButtonListener buttonListener;
    SessionProfileList currentProfileList;
    SessionProfile currentProfile;
    int currentIndex;
    ClientLoginHelpDialog helpDialog = null;
    JDialog thisDialog = this;

    public EditSessionProfileDialog(int n, SessionProfileList sessionProfileList) {
        this.setTitle("Edit Session Profile");
        this.setModal(true);
        this.currentProfileList = sessionProfileList;
        this.currentIndex = n;
        if (n < 0 || n >= sessionProfileList.size()) {
            this.currentProfile = new SessionProfile();
            this.currentIndex = -1;
        } else {
            this.currentProfile = (SessionProfile)sessionProfileList.get(n);
        }
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.nameGroup = new SplusGroupPanel("");
        this.centerPanel.add(this.nameGroup);
        this.sessionName = new SplusWideTextField("Profile Name", 'P');
        this.sessionName.setValue(this.currentProfile.getProfileName());
        this.nameGroup.add(this.sessionName);
        this.userGroup = new SplusGroupPanel("User");
        this.centerPanel.add(this.userGroup);
        this.userName = new SplusWideTextField("User Name", 'U');
        this.userName.setValue(this.currentProfile.getUserName());
        this.userGroup.add(this.userName);
        this.serverGroup = new SplusGroupPanel("Server");
        this.centerPanel.add(this.serverGroup);
        this.serverName = new SplusWideTextField("Server Host", 'S');
        this.serverName.setValue(this.currentProfile.getServerHost());
        this.serverGroup.add(this.serverName);
        this.cwdName = new SplusWideTextField("Work Directory", 'W');
        String string = this.currentProfile.getServerCwd();
        if (string.length() == 0) {
            this.cwdName.setValue("<Default>");
        } else {
            this.cwdName.setValue(string);
        }
        this.serverGroup.add(this.cwdName);
        this.helpOffValue = this.currentProfile.getHelpOff();
        this.helpHostValue = this.currentProfile.getHelpHost();
        if (this.helpHostValue.length() == 0) {
            this.helpHostValue = "<Default>";
        }
        this.serverRmiportValue = this.currentProfile.getServerRmiport();
        if (this.serverRmiportValue.length() == 0) {
            this.serverRmiportValue = "1099";
        }
        this.serverPromptValue = this.currentProfile.getServerPrompt();
        if (this.serverPromptValue.length() == 0) {
            this.serverPromptValue = "<Default>";
        }
        this.serverTelnetScriptValue = this.currentProfile.getServerTelnetScript();
        if (this.serverTelnetScriptValue.length() == 0) {
            this.serverTelnetScriptValue = "<Default>";
        }
        this.buttonListener = new ButtonListener();
        this.advancedButton = new SplusButton("Advanced", 'A');
        this.advancedButton.addActionListener(this.buttonListener);
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.advancedButton);
        box.add(Box.createHorizontalGlue());
        this.serverGroup.add(Box.createVerticalStrut(5));
        this.serverGroup.add(box);
        this.serverGroup.add(Box.createVerticalStrut(5));
        this.xserverGroup = new SplusGroupPanel("Display");
        this.centerPanel.add(this.xserverGroup);
        this.xserverDisplay = new SplusWideTextField("X Server Display", 'X');
        String string2 = this.currentProfile.getXserverDisplay();
        if (string2.length() == 0) {
            this.xserverDisplay.setValue("<Default>");
        } else {
            this.xserverDisplay.setValue(string2);
        }
        this.xserverGroup.add(this.xserverDisplay);
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("Save");
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.buttonListener);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this.buttonListener);
        if (this.currentIndex == -1) {
            this.removeButton.setEnabled(false);
        }
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.helpButton);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.registerKeyboardAction(this.buttonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.getRootPane().addKeyListener(new SplusAltKeyListener(this));
        Dimension dimension = SplusControlMetrics.getLabelDimension();
        Dimension dimension2 = new Dimension(4 * dimension.width + 60, dimension.height);
        this.centerPanel.add(new Box.Filler(dimension2, dimension2, dimension2));
        this.pack();
        Dimension dimension3 = this.getSize();
        Dimension dimension4 = this.getToolkit().getScreenSize();
        this.setLocation((dimension4.width - dimension3.width) / 2, (dimension4.height - dimension3.height) / 2);
    }

    public static void main(String[] stringArray) {
        new EditSessionProfileDialog(-1, new SessionProfileList()).show();
        System.exit(0);
    }

    private void saveProfileChanges() {
        this.currentProfile.setProfileName(this.sessionName.getValue());
        this.currentProfile.setUserName(this.userName.getValue());
        this.currentProfile.setServerHost(this.serverName.getValue());
        String string = this.cwdName.getValue();
        if (string.equals("<Default>")) {
            string = "";
        }
        this.currentProfile.setServerCwd(string);
        string = this.xserverDisplay.getValue();
        if (string.equals("<Default>")) {
            string = "";
        }
        this.currentProfile.setXserverDisplay(string);
        this.currentProfile.setHelpOff(this.helpOffValue);
        if (this.helpHostValue.equals("<Default>")) {
            this.helpHostValue = "";
        }
        this.currentProfile.setHelpHost(this.helpHostValue);
        this.currentProfile.setServerRmiport(this.serverRmiportValue);
        if (this.serverPromptValue.equals("<Default>")) {
            this.serverPromptValue = "";
        }
        this.currentProfile.setServerPrompt(this.serverPromptValue);
        if (this.serverTelnetScriptValue.equals("<Default>")) {
            this.serverTelnetScriptValue = "";
        }
        this.currentProfile.setServerTelnetScript(this.serverTelnetScriptValue);
        if (this.currentIndex == -1) {
            this.currentProfileList.addFirst(this.currentProfile);
        } else {
            this.currentProfileList.set(this.currentIndex, this.currentProfile);
        }
    }

    private boolean isComplete() {
        Object[] objectArray;
        int n;
        boolean bl = true;
        String string = "";
        if (bl && this.sessionName.getValue().trim().length() == 0) {
            bl = false;
            string = this.sessionName.getText() + " field requires a value.";
        }
        if (bl && this.userName.getValue().trim().length() == 0) {
            bl = false;
            string = this.userName.getText() + " field requires a value.";
        }
        if (bl && this.serverName.getValue().trim().length() == 0) {
            bl = false;
            string = this.serverName.getText() + " field requires a value.";
        }
        if (bl && this.userName.getValue().trim().equals("root")) {
            bl = false;
            string = "Root login not allowed.\nPlease specify a different user name.";
        }
        String string2 = this.sessionName.getValue().trim();
        String[] stringArray = this.currentProfileList.getProfileNames();
        SessionProfile sessionProfile = this.currentProfile;
        int n2 = this.currentIndex;
        if (bl && this.currentIndex != -1 && !string2.equals(stringArray[this.currentIndex]) && (n = JOptionPane.showOptionDialog(this, "Profile name has changed.  Save as a\nnew profile or rename the selected profile?", "Profile Name Changed", -1, 3, null, objectArray = new Object[]{"New", "Rename"}, objectArray[0])) == 0) {
            this.currentProfile = new SessionProfile();
            this.currentIndex = -1;
        }
        if (bl) {
            for (int i = 0; bl && i < stringArray.length; ++i) {
                if (i == this.currentIndex || !string2.equals(stringArray[i])) continue;
                bl = false;
                string = "New Profile Name matches an existing Profile Name.\nPlease specify a unique Profile Name.";
            }
        }
        if (!bl) {
            this.currentProfile = sessionProfile;
            this.currentIndex = n2;
            JOptionPane.showMessageDialog(this, string, "Profile Setup Error", 2);
        }
        return bl;
    }

    private void removeProfile() {
        Object[] objectArray;
        int n;
        if (this.currentIndex != -1 && (n = JOptionPane.showOptionDialog(this, "Remove this profile from the profile list?", "Remove Profile", -1, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0])) == 0) {
            this.currentProfileList.remove(this.currentIndex);
        }
    }

    private class LocalAdvancedDialog
    extends JDialog {
        SplusWideTextField helpHostField;
        SplusWideTextField serverRmiportField;
        SplusWideTextField serverPromptField;
        SplusWideTextField serverTelnetScriptField;
        SplusCheckBox helpOffCheckBox;
        JButton advancedOkButton;
        JButton advancedCancelButton;
        JButton advancedHelpButton;
        AdvancedButtonListener advancedButtonListener;
        ClientLoginHelpDialog advancedHelpDialog = null;
        JDialog advancedThisDialog = this;

        LocalAdvancedDialog() {
            this.setTitle("Advanced Session Profile Options");
            this.setModal(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Help");
            jPanel.add(splusGroupPanel);
            this.helpOffCheckBox = new SplusCheckBox("Help viewer off at startup", 'H');
            this.helpOffCheckBox.setValue(EditSessionProfileDialog.this.helpOffValue.length() > 0 ? "T" : "F");
            splusGroupPanel.add(this.helpOffCheckBox);
            this.helpHostField = new SplusWideTextField("Help System URL", 'U');
            this.helpHostField.setValue(EditSessionProfileDialog.this.helpHostValue);
            splusGroupPanel.add(this.helpHostField);
            SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Connection");
            jPanel.add(splusGroupPanel2);
            this.serverRmiportField = new SplusWideTextField("RMI Port", 'R');
            this.serverRmiportField.setValue(EditSessionProfileDialog.this.serverRmiportValue);
            splusGroupPanel2.add(this.serverRmiportField);
            this.serverPromptField = new SplusWideTextField("Telnet Prompt", 'T');
            this.serverPromptField.setValue(EditSessionProfileDialog.this.serverPromptValue);
            splusGroupPanel2.add(this.serverPromptField);
            this.serverTelnetScriptField = new SplusWideTextField("Telnet Script", 'S');
            this.serverTelnetScriptField.setValue(EditSessionProfileDialog.this.serverTelnetScriptValue);
            splusGroupPanel2.add(this.serverTelnetScriptField);
            JPanel jPanel2 = new JPanel();
            this.advancedButtonListener = new AdvancedButtonListener();
            this.advancedOkButton = new JButton("OK");
            this.advancedOkButton.addActionListener(this.advancedButtonListener);
            this.advancedCancelButton = new JButton("Cancel");
            this.advancedCancelButton.addActionListener(this.advancedButtonListener);
            this.advancedHelpButton = new JButton("Help");
            this.advancedHelpButton.addActionListener(this.advancedButtonListener);
            jPanel2.add(this.advancedOkButton);
            jPanel2.add(this.advancedCancelButton);
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add(this.advancedHelpButton);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)jPanel2, "South");
            this.getRootPane().setDefaultButton(this.advancedOkButton);
            this.advancedCancelButton.registerKeyboardAction(this.advancedButtonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
            this.getRootPane().addKeyListener(new SplusAltKeyListener(this));
            Dimension dimension = SplusControlMetrics.getLabelDimension();
            Dimension dimension2 = new Dimension(4 * dimension.width + 60, dimension.height);
            jPanel.add(new Box.Filler(dimension2, dimension2, dimension2));
            this.pack();
            Dimension dimension3 = this.getSize();
            Dimension dimension4 = this.getToolkit().getScreenSize();
            this.setLocation((dimension4.width - dimension3.width) / 2, (dimension4.height - dimension3.height) / 2);
        }

        private class AdvancedButtonListener
        implements ActionListener {
            private AdvancedButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton == LocalAdvancedDialog.this.advancedOkButton) {
                    EditSessionProfileDialog.this.helpOffValue = LocalAdvancedDialog.this.helpOffCheckBox.getValue() == "T" ? "true" : "";
                    EditSessionProfileDialog.this.helpHostValue = LocalAdvancedDialog.this.helpHostField.getValue();
                    EditSessionProfileDialog.this.serverRmiportValue = LocalAdvancedDialog.this.serverRmiportField.getValue();
                    EditSessionProfileDialog.this.serverPromptValue = LocalAdvancedDialog.this.serverPromptField.getValue();
                    EditSessionProfileDialog.this.serverTelnetScriptValue = LocalAdvancedDialog.this.serverTelnetScriptField.getValue();
                    LocalAdvancedDialog.this.dispose();
                } else if (jButton == LocalAdvancedDialog.this.advancedCancelButton) {
                    LocalAdvancedDialog.this.dispose();
                } else if (jButton == LocalAdvancedDialog.this.advancedHelpButton) {
                    if (LocalAdvancedDialog.this.advancedHelpDialog == null) {
                        LocalAdvancedDialog.this.advancedHelpDialog = new ClientLoginHelpDialog((Dialog)LocalAdvancedDialog.this.advancedThisDialog, "S-PLUS Client Login Help");
                    }
                    LocalAdvancedDialog.this.advancedHelpDialog.showTopic("Advanced_Session_Profile_Options_Dialog");
                }
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == EditSessionProfileDialog.this.okButton) {
                if (EditSessionProfileDialog.this.isComplete()) {
                    EditSessionProfileDialog.this.saveProfileChanges();
                    EditSessionProfileDialog.this.dispose();
                }
            } else if (jButton == EditSessionProfileDialog.this.cancelButton) {
                EditSessionProfileDialog.this.dispose();
            } else if (jButton == EditSessionProfileDialog.this.removeButton) {
                EditSessionProfileDialog.this.removeProfile();
                EditSessionProfileDialog.this.dispose();
            } else if (jButton == EditSessionProfileDialog.this.helpButton) {
                if (EditSessionProfileDialog.this.helpDialog == null) {
                    EditSessionProfileDialog.this.helpDialog = new ClientLoginHelpDialog((Dialog)EditSessionProfileDialog.this.thisDialog, "S-PLUS Client Login Help");
                }
                EditSessionProfileDialog.this.helpDialog.showTopic("Edit_Session_Profile_Dialog");
            } else if (jButton == EditSessionProfileDialog.this.advancedButton) {
                if (EditSessionProfileDialog.this.helpDialog != null) {
                    EditSessionProfileDialog.this.helpDialog.dispose();
                    EditSessionProfileDialog.this.helpDialog = null;
                }
                new LocalAdvancedDialog().show();
            }
        }
    }
}

