/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.commands;

import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.TextPrinter;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.util.FileUtilities;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class CommandsWindow
extends JInternalFrame
implements SplusPrintable,
CaretListener,
SaveAsable {
    private Object pasteLock = new Object();
    private SplusGui parentFrame;
    private JTextArea textArea;
    private int maxTextRows = 2048;
    private JScrollPane scrollPane;
    private int m_iMinCaretPos;
    private int lastValidCaret = 0;
    private boolean keywait = false;
    private boolean return_waiting = false;
    private TextPrinter m_print;
    private String m_strCmd = "";
    private String m_lastUnexecutedCmd = "";
    Vector historyVector = new Vector(10, 10);
    int historyIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandsWindow(SplusGui splusGui) {
        super("Commands Window", true, true, true, true);
        this.setFrameIcon(new ImageIcon(System.getProperty("splus.shome", "") + "/java/res/comwin.gif"));
        this.textArea = new SpecialPasteTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.parentFrame = splusGui;
        Object object = this.pasteLock;
        synchronized (object) {
            this.m_iMinCaretPos = this.textArea.getText().length();
            try {
                this.textArea.setCaretPosition(this.m_iMinCaretPos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        this.textArea.addCaretListener(this);
        object = new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                CommandsWindow.this.textArea.select(CommandsWindow.this.lastValidCaret, CommandsWindow.this.lastValidCaret);
            }
        };
        this.parentFrame.addWindowListener((WindowListener)object);
        this.textArea.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyTyped(KeyEvent keyEvent) {
                JTextArea jTextArea = CommandsWindow.this.textArea;
                synchronized (jTextArea) {
                    CommandsWindow.this.m_print = null;
                    if ((keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') && CommandsWindow.this.return_waiting) {
                        CommandsWindow.this.handleCarriageReturn();
                        CommandsWindow.this.return_waiting = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent keyEvent) {
                Object object;
                if (CommandsWindow.this.keywait) {
                    if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                        keyEvent.consume();
                        return;
                    }
                } else if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                    CommandsWindow.this.keywait = true;
                    object = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            CommandsWindow.this.keywait = false;
                        }
                    });
                    ((Thread)object).start();
                    CommandsWindow.this.return_waiting = true;
                }
                object = CommandsWindow.this.pasteLock;
                synchronized (object) {
                    int n = CommandsWindow.this.textArea.getText().length();
                    int n2 = 0;
                    if (n < CommandsWindow.this.m_iMinCaretPos) {
                        if (n > 0) {
                            CommandsWindow.this.textArea.insert("> ", n - 1);
                            CommandsWindow.this.m_iMinCaretPos = CommandsWindow.this.textArea.getText().length() - 1;
                            n2 = 1;
                        } else {
                            CommandsWindow.this.textArea.insert("> ", 0);
                            CommandsWindow.this.m_iMinCaretPos = CommandsWindow.this.textArea.getText().length();
                        }
                        try {
                            CommandsWindow.this.textArea.setCaretPosition(CommandsWindow.this.m_iMinCaretPos + n2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            illegalArgumentException.printStackTrace();
                        }
                    }
                    if (!(CommandsWindow.this.textArea.getCaretPosition() >= CommandsWindow.this.m_iMinCaretPos || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34 || keyEvent.getKeyCode() == 35 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 67 && keyEvent.isControlDown())) {
                        try {
                            CommandsWindow.this.textArea.setCaretPosition(CommandsWindow.this.m_iMinCaretPos);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            CommandsWindow.this.textArea.setCaretPosition(CommandsWindow.this.textArea.getText().length());
                        }
                    }
                    CommandsWindow.this.m_print = null;
                    if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
                        CommandsWindow.this.textArea.setCaretPosition(CommandsWindow.this.textArea.getText().length());
                    }
                    if (keyEvent.getKeyCode() == 226) {
                        keyEvent.setKeyCode(38);
                    }
                    if (keyEvent.getKeyCode() == 227) {
                        keyEvent.setKeyCode(37);
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            CommandsWindow.this.handleEscape();
                            break;
                        }
                        case 37: {
                            if (CommandsWindow.this.textArea.getCaretPosition() != CommandsWindow.this.m_iMinCaretPos) break;
                            keyEvent.consume();
                            break;
                        }
                        case 38: {
                            CommandsWindow.this.handleArrowUp();
                            keyEvent.consume();
                            break;
                        }
                        case 40: {
                            CommandsWindow.this.handleArrowDown();
                            keyEvent.consume();
                            break;
                        }
                        case 36: {
                            if (CommandsWindow.this.textArea.getCaretPosition() <= CommandsWindow.this.m_iMinCaretPos || keyEvent.isControlDown()) break;
                            try {
                                CommandsWindow.this.textArea.setCaretPosition(CommandsWindow.this.m_iMinCaretPos);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                illegalArgumentException.printStackTrace();
                            }
                            keyEvent.consume();
                            break;
                        }
                        case 8: {
                            int n3 = CommandsWindow.this.textArea.getCaretPosition();
                            if (n3 > CommandsWindow.this.m_iMinCaretPos) break;
                            if (CommandsWindow.this.m_lastUnexecutedCmd.length() > 0) {
                                CommandsWindow.this.m_lastUnexecutedCmd = CommandsWindow.this.m_lastUnexecutedCmd.substring(0, CommandsWindow.this.m_lastUnexecutedCmd.length() - 1);
                            }
                            CommandsWindow.this.textArea.insert(" ", CommandsWindow.this.textArea.getCaretPosition());
                        }
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        this.scrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add(this.scrollPane);
        this.setSize(700, 400);
    }

    private void handleCarriageReturn() {
        String string = this.textArea.getText().substring(this.m_iMinCaretPos).trim();
        string = string + "\n";
        this.m_strCmd = this.m_strCmd + this.m_lastUnexecutedCmd + string;
        this.append("");
        this.processCommand(this.m_strCmd, false);
        this.m_strCmd = "";
        this.m_lastUnexecutedCmd = "";
    }

    private void handleEscape() {
        this.parentFrame.interruptSplus();
    }

    private void handleArrowUp() {
        switch (this.historyIndex) {
            case -1: {
                if (this.historyVector.size() == 0) break;
                this.handleRollback(this.historyVector.size() - 1);
                this.m_lastUnexecutedCmd = "";
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.handleRollback(this.historyIndex - 1);
                this.m_lastUnexecutedCmd = "";
            }
        }
    }

    private void handleArrowDown() {
        switch (this.historyIndex) {
            case -1: {
                break;
            }
            default: {
                if (this.historyIndex == this.historyVector.size()) break;
                this.handleRollback(this.historyIndex + 1);
                this.m_lastUnexecutedCmd = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRollback(int n) {
        this.historyIndex = n;
        String string = n >= this.historyVector.size() ? "" : (String)this.historyVector.elementAt(n);
        Object object = this.pasteLock;
        synchronized (object) {
            this.textArea.replaceRange(string, this.m_iMinCaretPos, this.textArea.getText().length());
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(String string) {
        Object object = this.pasteLock;
        synchronized (object) {
            this.textArea.append(string);
            int n = this.textArea.getLineCount() - this.maxTextRows - 1;
            if (n > 0) {
                try {
                    this.textArea.replaceRange("", 0, this.textArea.getLineEndOffset(n));
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            this.m_iMinCaretPos = this.textArea.getText().length();
            try {
                this.textArea.setCaretPosition(this.m_iMinCaretPos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
    }

    public void processCommand(String string, boolean bl) {
        this.m_print = null;
        if (bl) {
            this.append("\n> " + string);
        }
        this.parentFrame.evaluateCommand(string);
        int n = 0;
        int n2 = 0;
        while (-1 != (n = string.indexOf(10, n2))) {
            String string2 = string.substring(n2, n).trim();
            n2 = n + 1;
            if (string2.length() <= 0) continue;
            this.historyVector.addElement(string2);
        }
        this.historyIndex = this.historyVector.size();
    }

    public int getNumberOfPages() {
        if (this.m_print == null) {
            this.m_print = new TextPrinter(this.textArea.getText(), this.textArea.getFont());
        }
        return this.m_print.getNumberOfPages();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.m_print == null) {
            this.m_print = new TextPrinter(this.textArea.getText(), this.textArea.getFont());
        }
        return this.m_print.print(graphics, pageFormat, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caretUpdate(CaretEvent caretEvent) {
        Object object = this.pasteLock;
        synchronized (object) {
            if (this.textArea.getCaretPosition() >= this.m_iMinCaretPos) {
                this.lastValidCaret = this.textArea.getCaretPosition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xPaste(String string) {
        int n = string.indexOf(10);
        int n2 = string.lastIndexOf(10);
        String string2 = string.substring(0, n2 != -1 ? n2 + 1 : string.length());
        Object object = this.pasteLock;
        synchronized (object) {
            this.textArea.append(string2);
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }
        if (n != -1) {
            this.handleCarriageReturn();
            if (n2 != -1 && n2 != n) {
                this.handleCarriageReturn();
            }
        }
        if (n2 != -1) {
            object = this.pasteLock;
            synchronized (object) {
                this.m_lastUnexecutedCmd = string.substring(n2 + 1);
                this.textArea.append(this.m_lastUnexecutedCmd);
                this.textArea.setCaretPosition(this.textArea.getText().length());
            }
        }
    }

    public File saveAs(Frame frame, File file) {
        JFileChooser jFileChooser = new JFileChooser(file, SplusSystem.getServerFileHandler().getServerFileSystemView());
        jFileChooser.setDialogType(1);
        if (jFileChooser.showSaveDialog(frame) == 0) {
            String string = ServerFile.convertServerFilePath(jFileChooser.getSelectedFile().getAbsolutePath());
            if (FileUtilities.confirmSaveAs(this.parentFrame, string)) {
                try {
                    FileOutputStream fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string);
                    fileOutputStream.write(this.textArea.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this.parentFrame, "Problem saving file:\n" + exception.getMessage(), "File Save Error", 2);
                }
            }
            return jFileChooser.getCurrentDirectory();
        }
        return file;
    }

    public void save() {
    }

    public int getMaxTextRows() {
        return this.maxTextRows;
    }

    public void setMaxTextRows(int n) {
        if (n > 0 && n < 16385) {
            this.maxTextRows = n;
        } else {
            System.out.println("Warning: Bad maxTextRow value (" + n + ") ignored");
        }
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void clear() {
        this.textArea.setText(null);
    }

    public void save(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string);
        fileOutputStream.write(this.textArea.getText().getBytes());
        fileOutputStream.close();
    }

    public class SpecialPasteTransferHandler
    extends TransferHandler {
        private DataFlavor myGetPropertyDataFlavor(Class clazz, DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavorArray[i];
                }
            }
            return null;
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            int n2;
            JTextComponent jTextComponent;
            int n3;
            Clipboard clipboard2 = jComponent.getToolkit().getSystemClipboard();
            Clipboard clipboard3 = jComponent.getToolkit().getSystemSelection();
            if (jComponent instanceof JTextComponent && (n3 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n2 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    StringSelection stringSelection = new StringSelection(string);
                    if (clipboard == clipboard2 || clipboard == clipboard3) {
                        if (clipboard2 != null) {
                            clipboard2.setContents(stringSelection, null);
                        }
                        if (clipboard3 != null) {
                            clipboard3.setContents(stringSelection, null);
                        }
                    } else {
                        clipboard.setContents(stringSelection, null);
                    }
                    if (n == 2) {
                        document.remove(n3, n2 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = this.myGetPropertyDataFlavor(String.class, transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                try {
                    char c;
                    Object object = transferable.getTransferData(dataFlavor);
                    String string = object.toString();
                    int n = string.length();
                    StringBuffer stringBuffer = new StringBuffer(n);
                    for (int i = 0; i < n && !Character.isIdentifierIgnorable(c = string.charAt(i)); ++i) {
                        stringBuffer.append(c);
                    }
                    CommandsWindow.this.xPaste(stringBuffer.toString());
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
            return false;
        }
    }

    public class SpecialPasteTextArea
    extends JTextArea {
        private TransferHandler myTH = null;

        public TransferHandler getTransferHandler() {
            if (this.myTH == null) {
                this.myTH = new SpecialPasteTransferHandler();
            }
            return this.myTH;
        }
    }
}

