/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RobustLTSRegressionDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;

    public RobustLTSRegressionDialog() {
        super("Robust LTS Linear Regression");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuLtsreg");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        this.weightsColumn.setEnabled(false);
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(3));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel3);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel3.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel3.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel3.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RobustLTSRegressionDialog.this.formulaField.setDependentValue(RobustLTSRegressionDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RobustLTSRegressionDialog.this.formulaField.setIndependentValue(RobustLTSRegressionDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(RobustLTSRegressionDialog.this.formulaField, RobustLTSRegressionDialog.this.dataSet, 2).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        splusGroupPanel3.add(box5);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("");
        box6.add(splusGroupPanel4);
        SplusTextField splusTextField2 = new SplusTextField("Number of Residuals in SS to Minimize", 'N');
        splusGroupPanel4.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "quan");
        box6.add(new SplusBoxFiller());
        box7.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box8);
        jPanel3.add(box9);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Printed Results");
        box8.add(splusGroupPanel5);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel5.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short.p");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Long Output", 'L');
        splusCheckBox3.setValue("T");
        splusGroupPanel5.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.long.p");
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Saved Results");
        box9.add(splusGroupPanel6);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel6.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel6.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "save.fit.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Residuals", 'R');
        splusGroupPanel6.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "save.resid.p");
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("LTS Weights (0's, 1's)", 'W');
        splusGroupPanel6.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.weights.p");
        box9.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box10);
        jPanel4.add(box11);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Plots");
        box10.add(splusGroupPanel7);
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel7.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Residuals vs Index", 'I');
        splusGroupPanel7.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "plotResidVsIndex.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel7.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "plotQQ.p");
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residuals vs Robust Distance", 'B');
        splusGroupPanel7.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox8, "plotResidVsDist.p");
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Options");
        box11.add(splusGroupPanel8);
        SplusTextField splusTextField3 = new SplusTextField("Number of Extreme Points to Identify:", 'X');
        splusTextField3.setValue("3");
        splusGroupPanel8.add(splusTextField3);
        splusFunctionInfo.add(splusTextField3, "id.n");
        box11.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }
}

