/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterFallback;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.WritableRandomIter;

public final class WritableRandomIterFallback
extends RandomIterFallback
implements WritableRandomIter {
    WritableRenderedImage wim;

    public WritableRandomIterFallback(WritableRenderedImage writableRenderedImage, Rectangle rectangle) {
        super(writableRenderedImage, rectangle);
        this.wim = writableRenderedImage;
    }

    public void done() {
        if (this.dataBuffer != null) {
            this.wim.releaseWritableTile(this.xID, this.yID);
        }
        this.dataBuffer = null;
    }

    private void makeCurrentWritable(int n, int n2) {
        int n3 = this.xTiles[n];
        int n4 = this.yTiles[n2];
        if (n3 != this.xID || n4 != this.yID || this.dataBuffer == null) {
            if (this.dataBuffer != null) {
                this.wim.releaseWritableTile(this.xID, this.yID);
            }
            this.xID = n3;
            this.yID = n4;
            WritableRaster writableRaster = this.wim.getWritableTile(this.xID, this.yID);
            this.dataBuffer = writableRaster.getDataBuffer();
            this.sampleModelTranslateX = writableRaster.getSampleModelTranslateX();
            this.sampleModelTranslateY = writableRaster.getSampleModelTranslateY();
        }
    }

    public void setPixel(int n, int n2, double[] dArray) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, float[] fArray) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, int[] nArray) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, d, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, float f) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, f, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, int n4) {
        this.makeCurrentWritable(n - this.boundsX, n2 - this.boundsY);
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, this.dataBuffer);
    }
}

