/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;
import javax.media.jai.TileCache;

final class ImageFunctionOpImage
extends SourcelessOpImage {
    protected ImageFunction function;
    protected float xScale;
    protected float yScale;
    protected float xTrans;
    protected float yTrans;
    private SoftReference dataCache = null;

    public ImageFunctionOpImage(ImageFunction imageFunction, int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, TileCache tileCache, ImageLayout imageLayout) {
        super(n, n2, n3, n4, ImageFunctionOpImage.sampleModelHelper(imageFunction.getNumElements() * (imageFunction.isComplex() ? 2 : 1), imageLayout), tileCache, imageLayout);
        this.function = imageFunction;
        this.xScale = f;
        this.yScale = f2;
        this.xTrans = f3;
        this.yTrans = f4;
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = this.sampleModel.getTransferType();
        int n2 = this.sampleModel.getNumBands();
        Object object = this.getMemory(n, this.width * this.height);
        if (n == 5) {
            double[] dArray = this.function.isComplex() ? ((double[][])object)[0] : (double[])object;
            double[] dArray2 = this.function.isComplex() ? ((double[][])object)[1] : null;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                this.function.getElements((double)(this.xScale * ((float)rectangle.x - this.xTrans)), (double)(this.yScale * ((float)rectangle.y - this.yTrans)), (double)this.xScale, (double)this.yScale, rectangle.width, rectangle.height, n3++, dArray, dArray2);
                writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n4, dArray);
                if (this.function.isComplex()) {
                    writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, ++n4, dArray2);
                }
                ++n4;
            }
        } else {
            float[] fArray = this.function.isComplex() ? ((float[][])object)[0] : (float[])object;
            float[] fArray2 = this.function.isComplex() ? ((float[][])object)[1] : null;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                this.function.getElements(this.xScale * ((float)rectangle.x - this.xTrans), this.yScale * ((float)rectangle.y - this.yTrans), this.xScale, this.yScale, rectangle.width, rectangle.height, n5++, fArray, fArray2);
                writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n6, fArray);
                if (this.function.isComplex()) {
                    writableRaster.setSamples(rectangle.x, rectangle.y, rectangle.width, rectangle.height, ++n6, fArray2);
                }
                ++n6;
            }
        }
    }

    private Object getMemory(int n, int n2) {
        Object object;
        block3: {
            block2: {
                object = null;
                if (this.dataCache == null) break block2;
                Object t = this.dataCache.get();
                object = t;
                if (t != null) break block3;
            }
            object = n == 5 ? (this.function.isComplex() ? (Object)new double[2][n2] : new double[n2]) : (Object)(this.function.isComplex() ? (Object)new float[2][n2] : new float[n2]);
            this.dataCache = new SoftReference<double[]>((double[])object);
        }
        return object;
    }

    private static SampleModel sampleModelHelper(int n, ImageLayout imageLayout) {
        SampleModel sampleModel;
        if (imageLayout != null && imageLayout.isValid(256)) {
            sampleModel = imageLayout.getSampleModel(null);
            if (sampleModel.getNumBands() != n) {
                throw new RuntimeException(JaiI18N.getString("ImageFunctionRIF0"));
            }
        } else {
            sampleModel = RasterFactory.createBandedSampleModel(4, 1, 1, n);
        }
        return sampleModel;
    }
}

