/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.launchconfigurations;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.launchconfigurations.WizardMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchCategoryFilter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.progress.UIJob;

public class ExportLaunchConfigurationsWizardPage
extends WizardPage {
    private String OVERWRITE = "overwrite";
    private String OLD_PATH = "oldpath";
    private CheckboxTreeViewer fViewer = null;
    private Text fFilePath = null;
    private Button fOverwrite = null;

    protected ExportLaunchConfigurationsWizardPage() {
        super(WizardMessages.ExportLaunchConfigurationsWizard_0);
        this.setTitle(WizardMessages.ExportLaunchConfigurationsWizard_0);
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        this.createViewer(comp);
        this.createFilePath(comp);
        this.fOverwrite = SWTFactory.createCheckButton(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_1, null, this.getDialogSettings().getBoolean(this.OVERWRITE), 2);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.export_launch_configurations_context");
        this.setMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_7);
        this.setPageComplete(false);
    }

    protected void createViewer(Composite parent) {
        SWTFactory.createWrapLabel(parent, WizardMessages.ExportLaunchConfigurationsWizardPage_3, 2);
        Tree tree = new Tree(parent, 2084);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tree.setLayoutData((Object)gd);
        this.fViewer = new CheckboxTreeViewer(tree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fViewer.setContentProvider((IContentProvider)new ConfigContentProvider());
        this.fViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes());
        this.fViewer.addFilter((ViewerFilter)new LaunchCategoryFilter("org.eclipse.ui.externaltools.builder"));
        this.fViewer.expandAll();
        this.fViewer.collapseAll();
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportLaunchConfigurationsWizardPage.this.updateCheckedState(event.getElement());
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
        Composite buttoncomp = SWTFactory.createComposite(parent, parent.getFont(), 2, 2, 768, 0, 0);
        Button button = SWTFactory.createPushButton(buttoncomp, WizardMessages.ExportLaunchConfigurationsWizardPage_8, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportLaunchConfigurationsWizardPage.this.fViewer.setAllChecked(true);
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
        button = SWTFactory.createPushButton(buttoncomp, WizardMessages.ExportLaunchConfigurationsWizardPage_9, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportLaunchConfigurationsWizardPage.this.fViewer.setAllChecked(false);
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
    }

    protected void updateCheckedState(Object element) {
        boolean state = this.fViewer.getChecked(element);
        if (element instanceof ILaunchConfigurationType) {
            Object[] items = ((ConfigContentProvider)this.fViewer.getContentProvider()).getChildren(element);
            int i = 0;
            while (i < items.length) {
                this.fViewer.setChecked(items[i], state);
                ++i;
            }
            this.fViewer.setGrayed(element, false);
        } else if (element instanceof ILaunchConfiguration) {
            ConfigContentProvider ccp = (ConfigContentProvider)this.fViewer.getContentProvider();
            Object parent = ccp.getParent(element);
            Object[] items = ccp.getChildren(parent);
            boolean checked = true;
            boolean onechecked = false;
            int i = 0;
            while (i < items.length) {
                state = this.fViewer.getChecked(items[i]);
                checked &= state;
                if (state) {
                    onechecked = true;
                }
                ++i;
            }
            this.fViewer.setGrayed(parent, onechecked & !checked);
            this.fViewer.setChecked(parent, checked | onechecked);
        }
    }

    protected void createFilePath(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 3, 2, 768, 0, 10);
        SWTFactory.createLabel(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_4, 1);
        this.fFilePath = SWTFactory.createText(comp, 2052, 1);
        String opath = this.getDialogSettings().get(this.OLD_PATH);
        this.fFilePath.setText(opath == null ? "" : opath);
        this.fFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
        Button button = SWTFactory.createPushButton(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_0, null, 3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path path;
                DirectoryDialog dd = new DirectoryDialog(ExportLaunchConfigurationsWizardPage.this.getContainer().getShell());
                dd.setText(WizardMessages.ExportLaunchConfigurationsWizard_0);
                String file = dd.open();
                if (file != null && (path = new Path(file)) != null) {
                    ExportLaunchConfigurationsWizardPage.this.fFilePath.setText(path.toString());
                    ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
                }
            }
        });
    }

    protected boolean isComplete() {
        Object[] elements = this.fViewer.getCheckedElements();
        boolean oneconfig = false;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ILaunchConfiguration) {
                oneconfig = true;
                break;
            }
            ++i;
        }
        if (elements.length < 1 || !oneconfig) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_5);
            return false;
        }
        String path = this.fFilePath.getText().trim();
        if (path.equals("")) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_6);
            return false;
        }
        if (new File(path).isFile()) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_2);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_7);
        return true;
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_EXPORT_CONFIGS");
    }

    public boolean finish() {
        final String dpath = this.fFilePath.getText().trim();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.OVERWRITE, this.fOverwrite.getSelection());
        settings.put(this.OLD_PATH, dpath);
        final Object[] configs = this.fViewer.getCheckedElements();
        final boolean overwrite = this.fOverwrite.getSelection();
        UIJob exportjob = new UIJob(this.getContainer().getShell().getDisplay(), WizardMessages.ExportLaunchConfigurationsWizard_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Path destpath;
                File destfolder;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (!(destfolder = (destpath = new Path(dpath)).toFile()).exists()) {
                    destfolder.mkdirs();
                }
                monitor.beginTask(WizardMessages.ExportLaunchConfigurationsWizardPage_10, configs.length);
                try {
                    File file = null;
                    File newfile = null;
                    boolean owall = false;
                    boolean nowall = false;
                    MessageDialog dialog = null;
                    int i = 0;
                    while (i < configs.length) {
                        block22: {
                            block23: {
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                if (configs[i] instanceof ILaunchConfiguration) {
                                    file = new File(((LaunchConfiguration)configs[i]).getLocation().toOSString());
                                    try {
                                        newfile = new File(destpath.append(file.getName()).toOSString());
                                        if (newfile.exists() & !overwrite) {
                                            if (nowall) break block22;
                                            dialog = new MessageDialog(DebugUIPlugin.getShell(), WizardMessages.ExportLaunchConfigurationsWizardPage_11, null, MessageFormat.format((String)WizardMessages.ExportLaunchConfigurationsWizardPage_12, (Object[])new String[]{file.getName()}), 3, new String[]{WizardMessages.ExportLaunchConfigurationsWizardPage_13, WizardMessages.ExportLaunchConfigurationsWizardPage_14, WizardMessages.ExportLaunchConfigurationsWizardPage_15, WizardMessages.ExportLaunchConfigurationsWizardPage_16, WizardMessages.ExportLaunchConfigurationsWizardPage_17}, 0);
                                            if (!owall) {
                                                int ret = dialog.open();
                                                switch (ret) {
                                                    case 0: {
                                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                                        break;
                                                    }
                                                    case 1: {
                                                        owall = true;
                                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                                        break;
                                                    }
                                                    case 3: {
                                                        nowall = true;
                                                        break;
                                                    }
                                                    case 4: {
                                                        monitor.setCanceled(true);
                                                    }
                                                }
                                            } else if (!nowall) {
                                                ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                            }
                                            break block23;
                                        }
                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                    }
                                    catch (Exception e) {
                                        DebugUIPlugin.logErrorMessage(e.getMessage());
                                    }
                                }
                            }
                            if (!monitor.isCanceled()) {
                                monitor.worked(1);
                            }
                        }
                        ++i;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        exportjob.schedule();
        return true;
    }

    protected void copyFile(File in, File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    class ConfigContentProvider
    implements ITreeContentProvider {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();

        ConfigContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ILaunchConfigurationType) {
                try {
                    return this.lm.getLaunchConfigurations((ILaunchConfigurationType)parentElement);
                }
                catch (Exception e) {
                    DebugUIPlugin.logErrorMessage(e.getMessage());
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ILaunchConfiguration) {
                try {
                    return ((ILaunchConfiguration)element).getType();
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ILaunchConfigurationType;
        }

        public Object[] getElements(Object inputElement) {
            return this.lm.getLaunchConfigurationTypes();
        }

        public void dispose() {
            this.lm = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

