/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

class ChildrenCountUpdate
extends ViewerUpdateMonitor
implements IChildrenCountUpdate {
    private int fCount = 0;
    private List fBatchedRequests = null;

    public ChildrenCountUpdate(ModelContentProvider contentProvider, Object viewerInput, TreePath elementPath, Object element, IElementContentProvider elementContentProvider, IPresentationContext context) {
        super(contentProvider, viewerInput, elementPath, element, elementContentProvider, context);
    }

    protected void performUpdate() {
        int viewCount = this.fCount;
        TreePath elementPath = this.getElementPath();
        if (viewCount == 0) {
            this.getContentProvider().clearFilters(elementPath);
        } else {
            this.getContentProvider().setModelChildCount(elementPath, this.fCount);
            viewCount = this.getContentProvider().modelToViewChildCount(elementPath, this.fCount);
        }
        if (ModelContentProvider.DEBUG_CONTENT_PROVIDER) {
            System.out.println("setChildCount(" + this.getElement() + ", modelCount: " + this.fCount + " viewCount: " + viewCount + ")");
        }
        ((TreeViewer)this.getContentProvider().getViewer()).setChildCount((Object)elementPath, viewCount);
        this.getContentProvider().doRestore(this.getElementPath(), -1, true, true);
    }

    public void setChildCount(int numChildren) {
        this.fCount = numChildren;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IChildrenCountUpdate: ");
        buf.append(this.getElement());
        return buf.toString();
    }

    boolean coalesce(ViewerUpdateMonitor request) {
        if (request instanceof ChildrenCountUpdate) {
            if (this.getElementPath().equals((Object)request.getElementPath())) {
                return true;
            }
            if (this.getElementContentProvider().equals(request.getElementContentProvider())) {
                if (this.fBatchedRequests == null) {
                    this.fBatchedRequests = new ArrayList();
                    this.fBatchedRequests.add(this);
                }
                this.fBatchedRequests.add(request);
                return true;
            }
        }
        return false;
    }

    void startRequest() {
        if (this.fBatchedRequests == null) {
            this.getElementContentProvider().update(new IChildrenCountUpdate[]{this});
        } else {
            IChildrenCountUpdate[] updates = this.fBatchedRequests.toArray(new IChildrenCountUpdate[this.fBatchedRequests.size()]);
            int i = 1;
            while (i < updates.length) {
                this.getContentProvider().updateStarted((ViewerUpdateMonitor)((Object)updates[i]));
                ++i;
            }
            this.getElementContentProvider().update(updates);
        }
    }

    int getPriority() {
        return 2;
    }

    TreePath getSchedulingPath() {
        TreePath path = this.getElementPath();
        if (path.getSegmentCount() > 0) {
            return path.getParentPath();
        }
        return path;
    }
}

