/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXParseException
extends SAXException {
    private String publicId;
    private String systemId;
    private int lineNumber;
    private int columnNumber;

    public SAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber) {
        super(message);
        this.init(publicId, systemId, lineNumber, columnNumber);
    }

    public SAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e) {
        super(message, e);
        this.init(publicId, systemId, lineNumber, columnNumber);
    }

    public SAXParseException(String message, Locator locator) {
        super(message);
        if (locator != null) {
            this.init(locator.getPublicId(), locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.init(null, null, -1, -1);
        }
    }

    public SAXParseException(String message, Locator locator, Exception e) {
        super(message, e);
        if (locator != null) {
            this.init(locator.getPublicId(), locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
        } else {
            this.init(null, null, -1, -1);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    private void init(String publicId, String systemId, int lineNumber, int columnNumber) {
        this.publicId = publicId;
        this.systemId = systemId;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }
}

