/*
 * Decompiled with CFR 0.152.
 */
package mediaLib;

import mediaLib.Constants;
import mediaLib.mediaLibException;

public class mediaLibImageInterpTable
implements Constants {
    protected int width;
    protected int height;
    protected int leftPadding;
    protected int topPadding;
    protected int subsampleBitsH;
    protected int subsampleBitsV;
    protected int precisionBits;
    protected int width_bits;
    protected int height_bits;
    protected int shift_vis;
    protected float[] dataH_float;
    protected float[] dataV_float;
    protected double[] dataH_double;
    protected double[] dataV_double;
    protected short[] dataH_short;
    protected short[] dataV_short;

    public mediaLibImageInterpTable(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object, Object object2) {
        int n9 = 0;
        int n10 = 0;
        int n11 = n2 - 1;
        while (n11 > 0) {
            ++n9;
            n11 >>= 1;
        }
        n11 = n3 - 1;
        while (n11 > 0) {
            ++n10;
            n11 >>= 1;
        }
        this.width = n2;
        this.height = n3;
        this.leftPadding = n4;
        this.topPadding = n5;
        this.subsampleBitsH = n6;
        this.subsampleBitsV = n7;
        this.width_bits = n9;
        this.height_bits = n10;
        if (n8 < 0 || n8 >= 31) {
            throw new mediaLibException(11);
        }
        if (n == 4 || n == 5) {
            this.precisionBits = 0;
        } else if (n == 1 || n == 2 || n == 3) {
            this.precisionBits = n8;
        } else {
            throw new mediaLibException(11);
        }
        this.dataH_double = this.CopyData(n, n6, n2, n9, this.precisionBits, object);
        float[] fArray = new float[this.dataH_double.length];
        n11 = 0;
        while (n11 < this.dataH_double.length) {
            fArray[n11] = (float)this.dataH_double[n11];
            ++n11;
        }
        this.dataH_float = fArray;
        if (object2 == null) {
            this.dataV_double = this.dataH_double;
            this.dataV_float = this.dataH_float;
        } else {
            this.dataV_double = this.CopyData(n, n7, n3, n10, this.precisionBits, object2);
            float[] fArray2 = new float[this.dataV_double.length];
            n11 = 0;
            while (n11 < this.dataV_double.length) {
                fArray2[n11] = (float)this.dataV_double[n11];
                ++n11;
            }
            this.dataV_float = fArray2;
        }
        int n12 = mediaLibImageInterpTable.CalcMaxBits(1 << n6, n2, n9, this.dataH_double);
        int n13 = mediaLibImageInterpTable.CalcMaxBits(1 << n7, n3, n10, this.dataV_double);
        this.shift_vis = 14 - n12 - 8 + (14 - n13) - 16;
        this.dataH_short = new short[(1 << n6) * (1 << n9)];
        this.dataV_short = new short[4 * (1 << n7) * (1 << n10)];
        if (n12 > 14 || n13 > 14 || this.shift_vis < 0) {
            this.shift_vis = -1;
        } else {
            double d = 1 << 14 - n12;
            int n14 = 0;
            while (n14 < n2) {
                n11 = 0;
                while (n11 < 1 << n6) {
                    short s;
                    this.dataH_short[(n11 << n9) + n14] = s = (short)(this.dataH_double[n14 + (n11 << n9)] * d);
                    ++n11;
                }
                ++n14;
            }
            d = 1 << 14 - n13;
            n14 = 0;
            while (n14 < n3) {
                n11 = 0;
                while (n11 < 1 << n7) {
                    short s;
                    this.dataV_short[4 * ((n11 << n10) + n14)] = s = (short)(this.dataV_double[n14 + (n11 << n10)] * d);
                    this.dataV_short[4 * ((n11 << n10) + n14) + 1] = s;
                    this.dataV_short[4 * ((n11 << n10) + n14) + 2] = s;
                    this.dataV_short[4 * ((n11 << n10) + n14) + 3] = s;
                    ++n11;
                }
                ++n14;
            }
        }
    }

    private static int CalcMaxBits(int n, int n2, int n3, double[] dArray) {
        double d = 0.0;
        int n4 = 0;
        while (n4 < n) {
            double d2 = 0.0;
            int n5 = 0;
            while (n5 < n2) {
                d2 += dArray[n5 + (n4 << n3)];
                ++n5;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n4;
        }
        int n6 = mediaLibImageInterpTable.mlib_ilogb(d);
        return n6;
    }

    private double[] CopyData(int n, int n2, int n3, int n4, int n5, Object object) {
        int n6;
        int n7 = 1 << n2;
        double d = 1.0 / (double)(1 << n5);
        double d2 = 0.0;
        double[] dArray = new double[n7 * (1 << n4)];
        if (object == null) {
            throw new NullPointerException();
        }
        switch (n) {
            case 1: {
                n6 = ((byte[])object).length;
                break;
            }
            case 2: {
                n6 = ((short[])object).length;
                break;
            }
            case 3: {
                n6 = ((int[])object).length;
                break;
            }
            case 4: {
                n6 = ((float[])object).length;
                break;
            }
            default: {
                n6 = ((double[])object).length;
            }
        }
        if (n6 != n7 * n3) {
            throw new mediaLibException(2);
        }
        int n8 = 0;
        while (n8 < n3) {
            int n9 = 0;
            while (n9 < n7) {
                switch (n) {
                    case 1: {
                        d2 = ((byte[])object)[n8 + n9 * n3] & 0xFF;
                        break;
                    }
                    case 2: {
                        d2 = ((short[])object)[n8 + n9 * n3];
                        break;
                    }
                    case 3: {
                        d2 = ((int[])object)[n8 + n9 * n3];
                        break;
                    }
                    case 4: {
                        d2 = ((float[])object)[n8 + n9 * n3];
                        break;
                    }
                    case 5: {
                        d2 = ((double[])object)[n8 + n9 * n3];
                    }
                }
                dArray[n8 + (n9 << n4)] = d2 * d;
                ++n9;
            }
            ++n8;
        }
        return dArray;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightBits() {
        return this.height_bits;
    }

    public double[] getHorizontalTableDataDouble() {
        return this.dataH_double;
    }

    public float[] getHorizontalTableDataFloat() {
        return this.dataH_float;
    }

    public short[] getHorizontalTableDataShort() {
        return this.dataH_short;
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public int getPrecisionBits() {
        return this.precisionBits;
    }

    public int getShiftVIS() {
        return this.shift_vis;
    }

    public int getSubsampleBitsH() {
        return this.subsampleBitsH;
    }

    public int getSubsampleBitsV() {
        return this.subsampleBitsV;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public double[] getVerticalTableDataDouble() {
        return this.dataV_double;
    }

    public float[] getVerticalTableDataFloat() {
        return this.dataV_float;
    }

    public short[] getVerticalTableDataShort() {
        return this.dataV_short;
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthBits() {
        return this.width_bits;
    }

    private static int mlib_ilogb(double d) {
        if (d == 0.0) {
            return -2147483647;
        }
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 32);
        int n2 = n & 0x7FF00000;
        if (n2 != 0) {
            n2 = n2 < 0x7FF00000 ? (n2 >> 20) - 1023 : Integer.MAX_VALUE;
        } else {
            double d2 = d * 4.503599627370496E15;
            l = Double.doubleToLongBits(d2);
            n = (int)(l >> 32);
            n2 = ((n & 0x7FF00000) >> 20) - 1075;
        }
        return n2;
    }
}

