/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.ParameterizedProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.osgi.util.NLS;

public class InstructionParser {
    InstallableUnitPhase phase;
    Touchpoint touchpoint;

    public InstructionParser(InstallableUnitPhase phase, Touchpoint touchpoint) {
        Assert.isNotNull((Object)phase);
        Assert.isNotNull((Object)touchpoint);
        this.phase = phase;
        this.touchpoint = touchpoint;
    }

    public ProvisioningAction[] parseActions(String instruction) {
        ArrayList<ProvisioningAction> actions = new ArrayList<ProvisioningAction>();
        StringTokenizer tokenizer = new StringTokenizer(instruction, ";");
        while (tokenizer.hasMoreTokens()) {
            actions.add(this.parseAction(tokenizer.nextToken()));
        }
        return actions.toArray(new ProvisioningAction[actions.size()]);
    }

    private ProvisioningAction parseAction(String statement) {
        int openBracket = statement.indexOf(40);
        int closeBracket = statement.lastIndexOf(41);
        String actionName = statement.substring(0, openBracket).trim();
        ProvisioningAction action = this.lookupAction(actionName);
        String nameValuePairs = statement.substring(openBracket + 1, closeBracket);
        StringTokenizer tokenizer = new StringTokenizer(nameValuePairs, ",");
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String nameValuePair = tokenizer.nextToken();
            int colonIndex = nameValuePair.indexOf(":");
            String name = nameValuePair.substring(0, colonIndex).trim();
            String value = nameValuePair.substring(colonIndex + 1).trim();
            parameters.put(name, value);
        }
        return new ParameterizedProvisioningAction(action, parameters);
    }

    private ProvisioningAction lookupAction(String actionId) {
        ProvisioningAction action = this.phase.getAction(actionId);
        if (action == null) {
            action = this.touchpoint.getAction(actionId);
        }
        if (action == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.action_not_found, (Object)actionId));
        }
        return action;
    }
}

