/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess;

import java.util.Hashtable;

class WebdavStatus {
    private static Hashtable mapStatusCodes = new Hashtable();
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_CONTINUE = 100;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_CONFLICT = 409;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_TOO_LONG = 413;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_MULTI_STATUS = 207;
    public static final int SC_UNPROCESSABLE_ENTITY = 418;
    public static final int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static final int SC_METHOD_FAILURE = 420;
    public static final int SC_LOCKED = 423;

    WebdavStatus() {
    }

    public static String getStatusText(int nHttpStatusCode) {
        Integer intKey = new Integer(nHttpStatusCode);
        if (!mapStatusCodes.containsKey(intKey)) {
            return "";
        }
        return (String)mapStatusCodes.get(intKey);
    }

    private static void addStatusCodeMap(int nKey, String strVal) {
        mapStatusCodes.put(new Integer(nKey), strVal);
    }

    static {
        WebdavStatus.addStatusCodeMap(200, "OK");
        WebdavStatus.addStatusCodeMap(201, "Created");
        WebdavStatus.addStatusCodeMap(202, "Accepted");
        WebdavStatus.addStatusCodeMap(204, "No Content");
        WebdavStatus.addStatusCodeMap(301, "Moved Permanently");
        WebdavStatus.addStatusCodeMap(302, "Moved Temporarily");
        WebdavStatus.addStatusCodeMap(304, "Not Modified");
        WebdavStatus.addStatusCodeMap(400, "Bad Request");
        WebdavStatus.addStatusCodeMap(401, "Unauthorized");
        WebdavStatus.addStatusCodeMap(403, "Forbidden");
        WebdavStatus.addStatusCodeMap(404, "Not Found");
        WebdavStatus.addStatusCodeMap(500, "Internal Server Error");
        WebdavStatus.addStatusCodeMap(501, "Not Implemented");
        WebdavStatus.addStatusCodeMap(502, "Bad Gateway");
        WebdavStatus.addStatusCodeMap(503, "Service Unavailable");
        WebdavStatus.addStatusCodeMap(100, "Continue");
        WebdavStatus.addStatusCodeMap(405, "Method Not Allowed");
        WebdavStatus.addStatusCodeMap(409, "Conflict");
        WebdavStatus.addStatusCodeMap(412, "Precondition Failed");
        WebdavStatus.addStatusCodeMap(413, "Request Too Long");
        WebdavStatus.addStatusCodeMap(415, "Unsupported Media Type");
        WebdavStatus.addStatusCodeMap(207, "Multi-Status");
        WebdavStatus.addStatusCodeMap(418, "Unprocessable Entity");
        WebdavStatus.addStatusCodeMap(419, "Insufficient Space On Resource");
        WebdavStatus.addStatusCodeMap(420, "Method Failure");
        WebdavStatus.addStatusCodeMap(423, "Locked");
    }
}

