/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGraphTextAWT;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

class SGraphText
extends SGraphTextAWT {
    public SGraphText(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        super(string, f, f2, f3, f4, f5, f6);
    }

    SGraphCommand getAWT() {
        SGraphTextAWT sGraphTextAWT = new SGraphTextAWT(this.m_txt, this.m_x, this.m_y, this.m_degrees_rotation, this.m_justification, this.m_fontSize, this.m_fontNumber);
        sGraphTextAWT.setCommonProperties(this);
        return sGraphTextAWT;
    }

    void print(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.display(sCanvasAWT, graphics);
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        Font font = sCanvasAWT.getFont(this.m_fontSize, this.m_fontNumber);
        String string = sCanvasAWT.getFontText(this.m_txt, this.m_fontNumber);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getDescent();
        double d = 0.5 * (double)(n + n2);
        int n3 = (int)Math.floor(d);
        int n4 = fontMetrics.stringWidth(string);
        int n5 = this.valToWindowX(sCanvasAWT, this.m_x);
        int n6 = this.valToWindowY(sCanvasAWT, this.m_y);
        if ((double)this.m_degrees_rotation < 3.0 || (double)this.m_degrees_rotation > 357.0) {
            int n7 = n5 - (int)((float)n4 * this.m_justification);
            int n8 = n6 - n3;
            this.setTextColor(sCanvasAWT, graphics);
            graphics.drawString(string, n7, n8 + n);
        } else {
            double d2 = (double)this.m_degrees_rotation / 180.0 * Math.PI;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            Graphics graphics2 = graphics.create();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            int n9 = n5 + (int)Math.round(-d3 * (double)n4 * (double)this.m_justification + d4 * ((double)n - d));
            int n10 = n6 + (int)Math.round(d4 * (double)n4 * (double)this.m_justification + d3 * ((double)n - d));
            graphics2D.translate(n9, n10);
            graphics2D.rotate(-d2);
            Color color = sCanvasAWT.getTextColor(this);
            graphics2D.setPaint(color);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
            graphics2D.drawString(string, 0, 0);
        }
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        float f = XML.getFloatProperty(xMLElement, "X", iDHash);
        float f2 = XML.getFloatProperty(xMLElement, "Y", iDHash);
        String string = XML.getStringProperty(xMLElement, "TEXT", iDHash);
        float f3 = XML.getFloatProperty(xMLElement, "FONTSIZE", iDHash);
        float f4 = XML.getFloatProperty(xMLElement, "FONTNUMBER", iDHash);
        float f5 = XML.getFloatProperty(xMLElement, "JUST", iDHash);
        float f6 = XML.getFloatProperty(xMLElement, "ROT", iDHash);
        return new SGraphText(string, f, f2, f6, f5, f3, f4);
    }
}

