/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.RemoteFileInputStream;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionFactory;
import com.insightful.splus.util.FileUtilities;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.Naming;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class SplusSSLServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    private SplusSession m_session = null;
    private String m_port = null;
    private String m_host = null;
    static SSLServerSocketFactory ssf = null;
    static String certfile = null;
    static String p = null;

    public SplusSSLServerSocketFactory() {
    }

    public SplusSSLServerSocketFactory(SplusSession splusSession) {
        this.m_session = splusSession;
    }

    private char[] getPassword(String string) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        MaskingThread maskingThread = new MaskingThread(string);
        Thread thread = new Thread(maskingThread);
        thread.start();
        while (true) {
            char c = (char)System.in.read();
            maskingThread.stopMasking();
            if (c == '\r') {
                c = (char)System.in.read();
                if (c != '\n') continue;
                break;
            }
            if (c == '\n') break;
            charArrayWriter.write(c);
        }
        char[] cArray = charArrayWriter.toCharArray();
        charArrayWriter.reset();
        return cArray;
    }

    static String getP() {
        return p;
    }

    static char[] readP(String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        for (n2 = cArray.length - 1; n2 > 0; --n2) {
            n = Character.getNumericValue(cArray[n2 - 1]);
            int n3 = n2;
            cArray[n3] = (char)(cArray[n3] + (n % 2 == 0 ? -1 : 1));
        }
        cArray[0] = (char)(cArray[0] - '\u0001');
        n2 = cArray.length;
        n = 0;
        while (0 < n2--) {
            cArray2[n] = cArray[n2];
            cArray[n2] = '\u0000';
            ++n;
        }
        return cArray2;
    }

    public static char[] getAccess() {
        String string = System.getProperty("splus.ssl.access");
        if (string == null || !string.equals("true")) {
            return SplusSSLServerSocketFactory.readP(SplusSSLServerSocketFactory.getP());
        }
        return SplusSSLServerSocketFactory.getPasswordFromSessionFactory();
    }

    public static String getCertfile() {
        return certfile;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (System.getProperty("splus.client.mode") != null) {
            return this.createClientSideServerSocket(n);
        }
        if (ssf == null) {
            try {
                String string;
                Object object;
                Object object2;
                char[] cArray = null;
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                String string2 = InetAddress.getLocalHost().getHostName();
                if (string2 == null || string2.length() == 0) {
                    System.out.println("Cannot determine hostname in createServerSocket");
                    System.exit(1);
                }
                if ((certfile = System.getProperty("splus.ssl.keystore")) == null || certfile.length() == 0) {
                    certfile = System.getProperty("splus.shome") + "/adm/spkey." + string2;
                    object2 = System.getProperty("splus.server.rmiport");
                    if (object2 != null && ((String)object2).length() != 0) {
                        try {
                            int n2 = Integer.decode((String)object2);
                            String string3 = certfile + "." + (String)object2;
                            object = new File(string3);
                            if (((File)object).exists()) {
                                if (((File)object).canRead()) {
                                    certfile = string3;
                                } else {
                                    System.out.println("Warning: read access to keystore, \"" + string3 + "\", " + "is denied.  Trying keystore \"" + certfile + "\".");
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!((File)(object2 = new File(certfile))).exists()) {
                    System.out.println("Cannot find keyfile, \"" + certfile + "\", in createServerSocket.");
                    System.exit(1);
                }
                if (!((File)object2).canRead()) {
                    System.out.println("Cannot read keyfile, \"" + certfile + "\", in createServerSocket.");
                    System.exit(1);
                }
                if ((string = System.getProperty("splus.ssl.access")) == null || !string.equals("true")) {
                    try {
                        cArray = this.getPassword("Enter password:");
                        int n3 = cArray.length;
                        object = new char[n3];
                        int n4 = 0;
                        while (0 < n3--) {
                            object[n3] = cArray[n4];
                            ++n4;
                        }
                        for (n4 = 0; n4 < ((char[])object).length; ++n4) {
                            int n5 = n4 == 0 ? 0 : Character.getNumericValue((char)object[n4 - 1]);
                            Object object3 = object;
                            int n6 = n4;
                            object3[n6] = (char)(object3[n6] + (n4 == 0 ? 1 : (n5 % 2 == 0 ? 1 : -1)));
                        }
                        p = new String((char[])object);
                    }
                    catch (Exception exception) {
                        System.out.println("Error while reading password:");
                        exception.printStackTrace();
                        System.exit(1);
                    }
                } else {
                    cArray = SplusSSLServerSocketFactory.getPasswordFromSessionFactory();
                }
                try {
                    keyStore.load(new FileInputStream(certfile), cArray);
                    keyManagerFactory.init(keyStore, cArray);
                }
                catch (Exception exception) {
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = '\u0000';
                    }
                    System.err.println("SSL init failed.  Check your password.");
                    exception.printStackTrace();
                    System.exit(1);
                }
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = '\u0000';
                }
                sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
                ssf = sSLContext.getServerSocketFactory();
            }
            catch (Exception exception) {
                System.err.println("SSL Factory init failed.");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        return ssf.createServerSocket(n);
    }

    static char[] getPasswordFromSessionFactory() {
        String string = null;
        String string2 = null;
        string = System.getProperty("splus.server.rmiport");
        if (string == null || string.length() == 0) {
            System.out.println("Bogus port when getting keystore");
            System.exit(1);
        }
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            System.out.println("Failed host lookup in getPasswordFromSessionFactory");
            System.exit(1);
        }
        String string3 = "rmi://" + string2 + ':' + string + "/SplusSessionServer";
        SplusSessionFactory splusSessionFactory = null;
        try {
            splusSessionFactory = (SplusSessionFactory)Naming.lookup(string3);
        }
        catch (Exception exception) {
            System.out.println("Factory not found when getting keystore");
            System.exit(1);
        }
        char[] cArray = null;
        try {
            cArray = splusSessionFactory.getAccess();
        }
        catch (Exception exception) {
            System.out.println("Access denied when getting keystore");
            System.exit(1);
        }
        return cArray;
    }

    public ServerSocket createClientSideServerSocket(int n) throws IOException {
        ServerSocketFactory serverSocketFactory = null;
        if (this.m_session == null) {
            System.out.println("Session object not set in createClientSideServerSocket");
            System.exit(1);
        }
        try {
            File file = null;
            char[] cArray = null;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("JKS");
            file = this.getCertfileFromSession();
            cArray = this.m_session.getCertAccess();
            try {
                keyStore.load(new FileInputStream(file.getCanonicalPath()), cArray);
                keyManagerFactory.init(keyStore, cArray);
            }
            catch (Exception exception) {
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = '\u0000';
                }
                file.delete();
                System.err.println("SSL init failed on client.  Check your password.");
                exception.printStackTrace();
                System.exit(1);
            }
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            file.delete();
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            serverSocketFactory = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            System.err.println("Client-side SSL Factory init failed.");
            exception.printStackTrace();
            System.exit(1);
        }
        return serverSocketFactory.createServerSocket(n);
    }

    File getCertfileFromSession() {
        File file = null;
        try {
            RemoteFileInputStream remoteFileInputStream = new RemoteFileInputStream(this.m_session.getCertFilename(), this.m_session);
            String string = System.getProperty("user.home");
            if (string == null || string.length() == 0) {
                System.out.println("Can't find user.home in getCertfileFromSession");
                System.exit(1);
            }
            file = File.createTempFile(".spcert", null, new File(string));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileUtilities.transferBytes(remoteFileInputStream, fileOutputStream);
            ((FileInputStream)remoteFileInputStream).close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Failure aquiring cert file from server");
            exception.printStackTrace();
            System.exit(1);
        }
        return file;
    }

    private class MaskingThread
    extends Thread {
        private boolean stop = false;
        private String myprompt;

        public MaskingThread(String string) {
            this.myprompt = string;
        }

        public void stopMasking() {
            this.stop = true;
        }

        public void run() {
            while (!this.stop) {
                System.out.print("\r" + this.myprompt + "   \b\b\b");
                try {
                    MaskingThread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

