/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusPasswordField;
import com.insightful.splus.SplusAltKeyListener;
import com.insightful.splus.SplusLogin;
import com.insightful.splus.SplusSession;
import com.insightful.splus.client.ClientLoginHelpDialog;
import com.insightful.splus.client.EditSessionProfileDialog;
import com.insightful.splus.client.SessionProfile;
import com.insightful.splus.client.SessionProfileList;
import com.insightful.splus.client.SwingWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ClientLoginDialog
extends JDialog {
    SessionProfileList profileList = new SessionProfileList();
    protected String[] m_vstrFactoryArgs = null;
    protected SplusSession m_session = null;
    protected SplusLogin m_login = null;
    SplusComboBox sessionField;
    SplusPasswordField passwordField;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    JButton editButton;
    JLabel m_lblProgress;
    ButtonListener buttonListener;
    JPanel buttonPanel;
    JPanel centerPanel;
    SplusGroupPanel leftPanel;
    SplusGroupPanel rightPanel;
    ClientLoginHelpDialog helpDialog = null;
    JDialog thisDialog = this;

    public void setFactoryArgs(String[] stringArray) {
        this.m_vstrFactoryArgs = stringArray;
    }

    public SplusSession getSession() {
        return this.m_session;
    }

    public String getHelpOff() {
        SessionProfile sessionProfile = (SessionProfile)this.profileList.get(this.sessionField.getSelectedIndex());
        return sessionProfile.getHelpOff();
    }

    public String getPassword() {
        return this.passwordField.getValue();
    }

    public SessionProfile getSelectedProfile() {
        return (SessionProfile)this.profileList.get(this.sessionField.getSelectedIndex());
    }

    public ClientLoginDialog() {
        this.setTitle("S-PLUS Client Login");
        this.setModal(true);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.buttonPanel = new JPanel();
        this.buttonListener = new ButtonListener();
        this.leftPanel = new SplusGroupPanel("");
        this.centerPanel.add(this.leftPanel);
        this.rightPanel = new SplusGroupPanel("");
        this.centerPanel.add(this.rightPanel);
        this.sessionField = new SplusComboBox("Session Profile", 'S', this.makeProfileNameOptionList());
        this.sessionField.setEditable(false);
        this.leftPanel.add(this.sessionField);
        this.passwordField = new SplusPasswordField("Password", 'P');
        this.passwordField.setValue(System.getProperty("splus.server.password", ""));
        this.leftPanel.add(this.passwordField);
        this.editButton = new JButton("Edit");
        this.editButton.setMnemonic('E');
        this.editButton.addActionListener(this.buttonListener);
        this.rightPanel.add(this.editButton);
        this.rightPanel.add(Box.createVerticalStrut(5));
        this.rightPanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(this.editButton.getPreferredSize().width, this.passwordField.getPreferredSize().height), this.passwordField.getMaximumSize()));
        this.m_lblProgress = new JLabel("", 0);
        this.m_lblProgress.setPreferredSize(new Dimension(SplusControlMetrics.getFullDimension().width, SplusControlMetrics.getLabelDimension().height));
        this.m_lblProgress.setMinimumSize(this.m_lblProgress.getPreferredSize());
        jPanel.add(this.m_lblProgress);
        this.okButton = new JButton("Login");
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.buttonListener);
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.helpButton);
        jPanel.add(this.m_lblProgress);
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.registerKeyboardAction(this.buttonListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.getRootPane().addKeyListener(new SplusAltKeyListener(this));
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setResizable(false);
    }

    public static void main(String[] stringArray) {
        new ClientLoginDialog().show();
        System.exit(0);
    }

    private String[] makeProfileNameOptionList() {
        String[] stringArray = this.profileList.getProfileNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = "<New Profile>";
        return stringArray2;
    }

    private boolean isComplete() {
        boolean bl = true;
        String string = "";
        String string2 = this.sessionField.getValue().trim();
        if (bl && string2.equals("<New Profile>")) {
            bl = false;
            string = "Profile settings needed for <New Profile>.\nPress the Edit button to specify settings.";
        }
        if (bl && string2.length() == 0) {
            bl = false;
            string = this.sessionField.getText() + " field requires a value.";
        }
        if (bl && this.passwordField.getValue().trim().length() == 0) {
            bl = false;
            string = this.passwordField.getText() + " field requires a value.";
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, string, "Required Field Error", 2);
        }
        return bl;
    }

    protected class LoginWorker
    extends SwingWorker {
        protected Exception m_ex = null;
        protected SessionProfile m_pflCurrent = null;

        public LoginWorker(SessionProfile sessionProfile) {
            this.m_pflCurrent = sessionProfile;
        }

        public Object construct() {
            ClientLoginDialog.this.m_login = new SplusLogin();
            ClientLoginDialog.this.m_login.setProgressUpdateCode(new UpdateProgressLabel());
            SplusSession splusSession = null;
            try {
                splusSession = ClientLoginDialog.this.m_login.newSession(this.m_pflCurrent, ClientLoginDialog.this.getPassword(), ClientLoginDialog.this.m_vstrFactoryArgs);
            }
            catch (SplusLogin.SplusLoginException splusLoginException) {
                this.m_ex = splusLoginException;
            }
            catch (SplusLogin.SplusLoginFatalException splusLoginFatalException) {
                this.m_ex = splusLoginFatalException;
            }
            return splusSession;
        }

        public void finished() {
            ClientLoginDialog.this.m_session = (SplusSession)this.get();
            if (this.m_ex == null) {
                ClientLoginDialog.this.dispose();
            } else {
                ClientLoginDialog.this.m_login = null;
                ClientLoginDialog.this.m_lblProgress.setText("");
                JOptionPane.showMessageDialog(ClientLoginDialog.this, this.m_ex.getMessage(), "Login Error", 0);
                ClientLoginDialog.this.okButton.setEnabled(true);
                if (this.m_ex instanceof SplusLogin.SplusLoginFatalException) {
                    ClientLoginDialog.this.dispose();
                }
            }
        }
    }

    protected class UpdateProgressLabel
    implements Runnable {
        protected UpdateProgressLabel() {
        }

        public void run() {
            if (ClientLoginDialog.this.m_login == null) {
                return;
            }
            ClientLoginDialog.this.m_lblProgress.setText(ClientLoginDialog.this.m_login.getProgressText());
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == ClientLoginDialog.this.okButton) {
                if (!ClientLoginDialog.this.isComplete()) {
                    return;
                }
                int n = ClientLoginDialog.this.sessionField.getSelectedIndex();
                SessionProfile sessionProfile = (SessionProfile)ClientLoginDialog.this.profileList.get(n);
                SplusLogin.setHelpHost(sessionProfile.getHelpHost());
                if (n != 0) {
                    ClientLoginDialog.this.profileList.remove(sessionProfile);
                    ClientLoginDialog.this.profileList.addFirst(sessionProfile);
                }
                ClientLoginDialog.this.profileList.store();
                ClientLoginDialog.this.sessionField.setOptionList(ClientLoginDialog.this.makeProfileNameOptionList());
                LoginWorker loginWorker = new LoginWorker(sessionProfile);
                loginWorker.start();
                ClientLoginDialog.this.okButton.setEnabled(false);
            } else if (jButton == ClientLoginDialog.this.cancelButton) {
                ClientLoginDialog.this.dispose();
            } else if (jButton == ClientLoginDialog.this.helpButton) {
                if (ClientLoginDialog.this.helpDialog == null) {
                    ClientLoginDialog.this.helpDialog = new ClientLoginHelpDialog((Dialog)ClientLoginDialog.this.thisDialog, "S-PLUS Client Login Help");
                }
                ClientLoginDialog.this.helpDialog.showTopic("S_PLUS_Client_Login_Dialog");
            } else if (jButton == ClientLoginDialog.this.editButton) {
                if (ClientLoginDialog.this.helpDialog != null) {
                    ClientLoginDialog.this.helpDialog.dispose();
                    ClientLoginDialog.this.helpDialog = null;
                }
                String[] stringArray = ClientLoginDialog.this.sessionField.getOptionList();
                int n = ClientLoginDialog.this.sessionField.getSelectedIndex();
                new EditSessionProfileDialog(n, ClientLoginDialog.this.profileList).show();
                String[] stringArray2 = ClientLoginDialog.this.makeProfileNameOptionList();
                ClientLoginDialog.this.sessionField.setOptionList(stringArray2);
                if (stringArray.length != stringArray2.length) {
                    n = 0;
                }
                ClientLoginDialog.this.sessionField.setSelectedIndex(n);
            }
        }
    }
}

