/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusWideFormulaField;
import com.insightful.splus.statdlg.RegressionFormulaDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DiscriminantAnalysisDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox weightsColumn;
    SplusDataColumnComboBox freqColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideFormulaField formulaField;
    SplusButton formulaButton;
    SplusComboBox family;
    SplusComboBox cov;
    SplusComboBox prior;
    SplusCheckBox savePlugIn;
    SplusCheckBox savePredictive;
    SplusCheckBox saveCross;
    SplusCheckBox saveUnbiased;
    CvActionListener cvActionListener;
    FamilyActionListener familyActionListener;

    public DiscriminantAnalysisDialog() {
        super("Discriminant Analysis");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuDiscrim");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        this.cvActionListener = new CvActionListener();
        this.familyActionListener = new FamilyActionListener();
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        this.weightsColumn = new SplusDataColumnComboBox("Weights", 'W', (SplusDataColumnListProvider)this.dataSet);
        this.weightsColumn.setValue("");
        splusGroupPanel.add(this.weightsColumn);
        splusFunctionInfo.add(this.weightsColumn, "weights");
        this.weightsColumn.addActionListener(this.cvActionListener);
        this.freqColumn = new SplusDataColumnComboBox("Frequencies", 'Q', (SplusDataColumnListProvider)this.dataSet);
        this.freqColumn.setValue("");
        splusGroupPanel.add(this.freqColumn);
        splusFunctionInfo.add(this.freqColumn, "frequencies");
        this.freqColumn.addActionListener(this.cvActionListener);
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "naOmit");
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Model");
        box4.add(splusGroupPanel2);
        this.family = new SplusComboBox("Family", 'A', new String[]{"classical", "principal component", "canonical"});
        this.family.setEditable(false);
        this.family.setValue("classical");
        splusGroupPanel2.add(this.family);
        splusFunctionInfo.add(this.family, "family", true);
        this.family.addActionListener(this.familyActionListener);
        this.cov = new SplusComboBox("Covariance Struct", 'C', new String[]{"homoscedastic", "spherical", "proportional", "group spherical", "equal correlation", "heteroscedastic"});
        this.cov.setEditable(false);
        this.cov.setValue("homoscedastic");
        splusGroupPanel2.add(this.cov);
        splusFunctionInfo.add(this.cov, "cov.structure", true);
        this.cov.addActionListener(this.cvActionListener);
        this.prior = new SplusComboBox("Group Prior", 'G', new String[]{"none", "proportional", "uniform"});
        this.prior.setEditable(false);
        this.prior.setValue("proportional");
        splusGroupPanel2.add(this.prior);
        splusFunctionInfo.add(this.prior, "prior", true);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel3);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel3.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        box4.add(new SplusBoxFiller(5));
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Variables");
        box2.add(splusGroupPanel4);
        this.dependentColumn = new SplusDataColumnComboBox("Dependent", 'E', (SplusDataColumnListProvider)this.dataSet);
        this.dependentColumn.setValue("");
        splusGroupPanel4.add(this.dependentColumn);
        splusFunctionInfo.add(this.dependentColumn, "");
        this.independentColumnList = new SplusDataColumnListBox("Independent", 'I', (SplusDataColumnListProvider)this.dataSet);
        this.independentColumnList.setPrepend(new String[]{"<ALL>"});
        splusGroupPanel4.add(this.independentColumnList);
        splusFunctionInfo.add(this.independentColumnList, "");
        this.formulaField = new SplusWideFormulaField();
        splusGroupPanel4.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "formula");
        this.dependentColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscriminantAnalysisDialog.this.formulaField.setDependentValue(DiscriminantAnalysisDialog.this.dependentColumn.getValue());
            }
        });
        this.independentColumnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DiscriminantAnalysisDialog.this.formulaField.setIndependentValue(DiscriminantAnalysisDialog.this.independentColumnList.getValue());
            }
        });
        this.formulaButton = new SplusButton("Create Formula", 'C');
        this.formulaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new RegressionFormulaDialog(DiscriminantAnalysisDialog.this.formulaField, DiscriminantAnalysisDialog.this.dataSet, 1).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.formulaButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        splusGroupPanel4.add(box5);
        splusGroupPanel4.add(Box.createVerticalStrut(5));
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Results", jPanel2);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box6);
        jPanel2.add(box7);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Printed/Graphic Results");
        box6.add(splusGroupPanel5);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel5.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "printShort");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Long Output", 'L');
        splusCheckBox3.setValue("T");
        splusGroupPanel5.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "printLong");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("Plot", 'O');
        splusGroupPanel5.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "doPlots");
        box6.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Saved Results");
        box7.add(splusGroupPanel6);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel6.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "predResult", true);
        this.savePlugIn = new SplusCheckBox("Plug-in", 'P');
        splusGroupPanel6.add(this.savePlugIn);
        splusFunctionInfo.add(this.savePlugIn, "plugIn");
        this.savePredictive = new SplusCheckBox("Predictive", 'R');
        splusGroupPanel6.add(this.savePredictive);
        splusFunctionInfo.add(this.savePredictive, "predictive");
        this.saveUnbiased = new SplusCheckBox("Unbiased", 'U');
        splusGroupPanel6.add(this.saveUnbiased);
        splusFunctionInfo.add(this.saveUnbiased, "unbiased");
        this.saveCross = new SplusCheckBox("Cross-Validate", 'C');
        splusGroupPanel6.add(this.saveCross);
        splusFunctionInfo.add(this.saveCross, "crossValidate");
        box7.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.formulaField);
    }

    private final class FamilyActionListener
    implements ActionListener {
        private FamilyActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DiscriminantAnalysisDialog.this.family.getValue();
            String string2 = DiscriminantAnalysisDialog.this.cov.getValue();
            boolean bl = false;
            boolean bl2 = true;
            if (string.equals("classical")) {
                DiscriminantAnalysisDialog.this.cov.setOptionList(new String[]{"homoscedastic", "spherical", "proportional", "group spherical", "equal correlation", "heteroscedastic"});
                if (string2.equals("common principal component")) {
                    DiscriminantAnalysisDialog.this.cov.setValue("homoscedastic");
                    bl = true;
                } else {
                    bl = string2.equals("homoscedastic") || string2.equals("heteroscedastic") || string2.equals("spherical") || string2.equals("group spherical") || string2.equals("");
                }
            } else if (string.equals("principal component")) {
                DiscriminantAnalysisDialog.this.cov.setOptionList(new String[]{"proportional", "common principal component"});
                if (!string2.equals("proportional")) {
                    DiscriminantAnalysisDialog.this.cov.setValue("common principal component");
                }
            } else {
                DiscriminantAnalysisDialog.this.cov.setOptionList(new String[]{"homoscedastic"});
                DiscriminantAnalysisDialog.this.cov.setValue("homoscedastic");
                bl = true;
                bl2 = false;
            }
            if (!bl) {
                DiscriminantAnalysisDialog.this.saveCross.setValue("F");
            }
            if (!bl2) {
                DiscriminantAnalysisDialog.this.savePredictive.setValue("F");
                DiscriminantAnalysisDialog.this.saveUnbiased.setValue("F");
            }
            DiscriminantAnalysisDialog.this.saveCross.setEnabled(bl);
            DiscriminantAnalysisDialog.this.savePredictive.setEnabled(bl2);
            DiscriminantAnalysisDialog.this.saveUnbiased.setEnabled(bl2);
        }
    }

    private final class CvActionListener
    implements ActionListener {
        private CvActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DiscriminantAnalysisDialog.this.family.getValue();
            String string2 = DiscriminantAnalysisDialog.this.cov.getValue();
            boolean bl = false;
            if (string.equals("canonical") || string.equals("classical") && (string2.equals("homoscedastic") || string2.equals("heteroscedastic") || string2.equals("spherical") || string2.equals("group spherical") || string2.equals(""))) {
                bl = true;
            }
            boolean bl2 = bl = bl && DiscriminantAnalysisDialog.this.weightsColumn.getValue().trim().length() == 0 && DiscriminantAnalysisDialog.this.freqColumn.getValue().trim().length() == 0;
            if (!bl) {
                DiscriminantAnalysisDialog.this.saveCross.setValue("F");
            }
            DiscriminantAnalysisDialog.this.saveCross.setEnabled(bl);
        }
    }
}

