/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerTextEdit;
import com.insightful.miner.MultiLineDocument;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoTextEdit;
import com.nwoods.jgo.JGoView;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class BaseNodeLabel
extends JGoText {
    protected JGoTextEdit editor = null;

    public BaseNodeLabel() {
    }

    public BaseNodeLabel(String text, JGoArea parent) {
        this.initialize(text, parent);
        this.setText(MultiLineDocument.formatString(text, this.isMultiline()));
    }

    public void initialize(String text, JGoArea parent) {
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        this.setVisible(true);
        this.setEditable(true);
        this.setEditOnSingleClick(true);
        this.setTransparent(false);
        this.setAlignment(1);
        this.setTopLeft(parent.getLeft(), parent.getTop());
        parent.addObjectAtTail((JGoObject)this);
        this.setMultiline(true);
    }

    public void doStartEdit(JGoView view, Point vc) {
        JComponent comp;
        if (view == null) {
            return;
        }
        if (view.getDocument() != null) {
            view.getDocument().startTransaction();
        }
        view.getSelection().clearSelectionHandles((JGoObject)this);
        Rectangle rect = new Rectangle(this.getBoundingRect());
        String str = this.getText();
        int numLines = 0;
        int endingIndex = 0;
        int startingIndex = 0;
        while (endingIndex > -1) {
            endingIndex = str.indexOf(10, startingIndex);
            startingIndex = endingIndex + 1;
            ++numLines;
        }
        if (this.isMultiline()) {
            rect.height += this.getHeight() / numLines;
        }
        view.setEditControl((JGoTextEdit)new MinerTextEdit(rect, this.getText(), this.isMultiline(), this));
        this.editor = view.getEditControl();
        if (this.editor != null && (comp = this.editor.getComponent(view)) instanceof JTextComponent) {
            JTextComponent jtext = (JTextComponent)comp;
            jtext.selectAll();
            jtext.grabFocus();
            this.setVisible(false);
        }
    }

    public void doEndEdit() {
        JGoArea obj;
        JGoView view = null;
        if (this.editor != null) {
            view = this.editor.getView();
            if (view != null) {
                this.setVisible(true);
                view.setEditControl(null);
            }
            this.editor = null;
            if (view != null) {
                view.getSelection().restoreSelectionHandles((JGoObject)this);
                view.grabFocus();
                if (view.getDocument() != null) {
                    view.getDocument().endTransaction(view.getEditPresentationName(7));
                }
            }
        }
        if ((obj = this.getParent()) instanceof BaseNodeArea) {
            ((BaseNodeArea)obj).setText(this.getText());
        }
        obj = this.getTopLevelObject();
        if (view != null) {
            JGoSelection sel = view.getSelection();
            sel.clearSelection((JGoObject)obj);
            sel.extendSelection((JGoObject)obj);
        }
    }
}

