/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class ChartEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    protected ByColumnStatisticAccumulator m_stats = null;
    protected int m_numByColumns = 0;
    protected int m_numDisplayColumns = 0;
    protected long m_totalRowCount = 0L;
    protected int m_lastPercentage = 0;
    protected int[] m_interestColumns = null;
    protected int[] m_byColumns = null;
    protected boolean m_boxPlot = false;
    protected boolean m_conditioned = false;
    protected boolean m_secondPass = false;
    protected int m_finishCount = 0;
    protected String m_originalStatus = null;
    public static String BIN_COUNT_CACHE_FILENAME = "bin.cache";
    public static String QUANTILE_COUNT_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.QUANTILE_COUNT_ATTRIBUTE_TAG;
    public static String K_VALUE_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.K_VALUE_ATTRIBUTE_TAG;
    public static String MINIMUM_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.MINIMUM_ATTRIBUTE_TAG;
    public static String MAXIMUM_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.MAXIMUM_ATTRIBUTE_TAG;
    public static String MEAN_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.MEAN_ATTRIBUTE_TAG;
    public static String STANDARD_DEVIATION_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.STANDARD_DEVIATION_ATTRIBUTE_TAG;
    public static String QUANTILES_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.QUANTILES_ATTRIBUTE_TAG;
    public static String BINS_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.BINS_ATTRIBUTE_TAG;
    public static String STATS_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.STATS_ATTRIBUTE_TAG;
    public static String LOW_VALUE_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.LOW_VALUE_ATTRIBUTE_TAG;
    public static String HIGH_VALUE_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.HIGH_VALUE_ATTRIBUTE_TAG;
    public static String COUNT_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.COUNT_ATTRIBUTE_TAG;
    public static String NAN_ATTRIBUTE_TAG = ByColumnStatisticAccumulator.NAN_ATTRIBUTE_TAG;
    public static String QUANTILE_COUNT_DEFAULT = "4";
    public static String K_VALUE_DEFAULT = "100";
    public static int NUM_BARS_DEFAULT = 10;
    public static String GROUPBY_ATTRIBUTE_TAG = "groupby";
    public static String DISPLAY_ATTRIBUTE_TAG = "display";
    public static String NUM_BARS_ATTRIBUTE_TAG = "numBars";
    public static String SHOW_STATISTICS_TAG = "showstats";
    public static String SHOW_PERCENTS_TAG = "showpercents";
    public static String RELATIVE_TAG = "relative";
    public static String[] m_chartTypes = new String[]{"histogram", "boxplot", "dotchart", "barchart", "piechart", "columnchart"};
    public static int HISTOGRAM_POS = 0;
    public static int BOXPLOT_POS = 1;
    public static int DOTCHART_POS = 2;
    public static int BARCHART_POS = 3;
    public static int PIECHART_POS = 4;
    public static int COLUMNCHART_POS = 5;

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public int getBinCount() {
        return 10;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        try {
            this.allocateByColumnStatistics();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void procExtractResults(CNKProc proc) {
        try {
            XTProps cache = this.m_stats.outputColumnStats();
            this.setNodeCache(BIN_COUNT_CACHE_FILENAME, cache);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        long start;
        if (this.m_numDisplayColumns == 0) {
            proc.setError("No display columns selected.");
        }
        if ((start = proc.getChunkInputPosition(0)) == 0L) {
            String str = null;
            if (this.m_originalStatus == null) {
                this.m_originalStatus = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
            }
            str = !this.m_secondPass ? this.m_originalStatus + ": Collecting chart info..." : this.m_originalStatus + ": Collecting quantile info...";
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        }
        this.accumulateStats(proc);
        long chunk = proc.getChunkInputRows(0);
        long total = proc.getChunkInputTotalRows(0);
        if (this.m_conditioned && this.m_boxPlot) {
            if (start + chunk == total && this.m_finishCount < 2) {
                this.resetProgressIndicator();
                ++this.m_finishCount;
                if (!this.m_secondPass) {
                    proc.setChunkNextInputPosition(0, 0L);
                    proc.setChunkNextRowsDone(0L);
                    this.m_secondPass = true;
                    this.m_lastPercentage = 0;
                }
            }
        } else if (start + chunk == total && this.m_finishCount < 1) {
            this.resetProgressIndicator();
            ++this.m_finishCount;
        }
    }

    public void accumulateStats(CNKProcJavaTransform proc) {
        int inputRows = proc.getChunkInputRows(0);
        Object actualByColumns = new double[this.m_numByColumns][];
        for (int i = 0; i < this.m_numByColumns; ++i) {
            actualByColumns[i] = proc.getChunkInputColumnData(0, this.m_byColumns[i]);
        }
        Object actualInterestColumns = new double[this.m_numDisplayColumns][];
        for (int i = 0; i < this.m_numDisplayColumns; ++i) {
            actualInterestColumns[i] = proc.getChunkInputColumnData(0, this.m_interestColumns[i]);
        }
        long curPos = proc.getChunkInputPosition(0);
        int percent = (int)((double)curPos / (double)this.m_totalRowCount * 100.0);
        if (!this.updateProgressIndicator(percent)) {
            return;
        }
        try {
            if (this.m_secondPass) {
                this.m_stats.updateStatisticsSecondPass((double[][])actualByColumns, (double[][])actualInterestColumns, inputRows);
            } else {
                this.m_stats.updateStatistics((double[][])actualByColumns, (double[][])actualInterestColumns, inputRows);
            }
        }
        catch (OutOfMemoryError oom) {
            actualInterestColumns = null;
            actualByColumns = null;
            this.m_stats = null;
            System.gc();
            this.printlnError("Out of memory while trying to accumulate chart statistics.");
        }
    }

    protected void allocateByColumnStatistics() throws Exception {
        int i;
        XTMetaData metaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector byVec = this.getDisplayColumns(props, metaData, GROUPBY_ATTRIBUTE_TAG);
        Vector displayVec = this.getDisplayColumns(props, metaData, DISPLAY_ATTRIBUTE_TAG);
        int numQuantiles = props.getInt(QUANTILE_COUNT_ATTRIBUTE_TAG, 4);
        int quantileKValue = props.getInt(K_VALUE_ATTRIBUTE_TAG, 100);
        this.m_numByColumns = byVec.size();
        this.m_numDisplayColumns = displayVec.size();
        if (this.m_numDisplayColumns == 0) {
            return;
        }
        this.m_totalRowCount = metaData.getNumRows();
        this.m_stats = new ByColumnStatisticAccumulator(byVec, displayVec, numQuantiles, quantileKValue, metaData);
        this.m_stats.setBinCount(props.getInt(NUM_BARS_ATTRIBUTE_TAG, NUM_BARS_DEFAULT));
        int size = byVec.size();
        this.m_byColumns = new int[size];
        for (i = 0; i < size; ++i) {
            this.m_byColumns[i] = metaData.nameToOrdinal((String)byVec.get(i));
        }
        size = byVec.size();
        this.m_interestColumns = new int[displayVec.size()];
        for (i = 0; i < displayVec.size(); ++i) {
            this.m_interestColumns[i] = metaData.nameToOrdinal((String)displayVec.get(i));
        }
        this.m_boxPlot = props.getBoolean(m_chartTypes[BOXPLOT_POS], false);
        this.m_conditioned = this.m_numByColumns > 0;
        this.m_stats.calculateOnlyBinCounts();
        this.m_finishCount = 0;
        this.m_lastPercentage = 0;
        this.m_secondPass = false;
        this.m_originalStatus = null;
    }

    protected Vector getDisplayColumns(XTProps dialogProps, XTMetaData inputMD, String name) {
        Vector cols = dialogProps.getSubProperties(name);
        try {
            int numCols = cols.size();
            for (int i = numCols - 1; i >= 0; --i) {
                if (!inputMD.isStringColumn((String)cols.get(i))) continue;
                cols.remove(i);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return cols;
    }
}

